/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.rule;

import cn.minsin.core.annotation.NotNull;
import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.tools.StringUtil;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelRule
implements Serializable {
    private static final long serialVersionUID = 57625408003186203L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String ERROR_MESSAGE_TEMPLATE = " '%s' Can't be empty,This field means '%s'";

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    protected SortedMap<String, String> toTreeMap() throws MutilsErrorException {
        boolean flag = false;
        TreeMap<String, String> tree = new TreeMap<String, String>();
        for (Field field : this.getAllFields()) {
            if (this.verificationField(field)) continue;
            NotNull annotation = field.getAnnotation(NotNull.class);
            try {
                String key = field.getName();
                field.setAccessible(true);
                Object object = field.get(this);
                if (annotation != null && annotation.notNull() && StringUtil.isBlank(object)) {
                    String description = annotation.value();
                    throw new MutilsException(String.format(" '%s' Can't be empty,This field means '%s'", key, description));
                }
                if (StringUtil.isBlank(object)) continue;
                tree.put(key, object.toString());
            }
            catch (Exception e) {
                flag = true;
                e.printStackTrace();
            }
        }
        if (flag) {
            throw new MutilsErrorException("Some fields is null.Program termination");
        }
        return tree;
    }

    protected Set<Field> getAllFields() {
        HashSet<Field> hashset = new HashSet<Field>();
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            hashset.addAll(Arrays.asList(fields));
        }
        return hashset;
    }

    public void verificationField() {
        for (Field field : this.getAllFields()) {
            NotNull annotation;
            if (this.verificationField(field) || (annotation = field.getAnnotation(NotNull.class)) == null || !annotation.notNull()) continue;
            try {
                String key = field.getName();
                field.setAccessible(true);
                Object object = field.get(this);
                if (!StringUtil.isBlank(object)) continue;
                String description = annotation.value();
                throw new MutilsException(String.format(" '%s' Can't be empty,This field means '%s'", key, description));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean verificationField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) || !Modifier.isPrivate(modifiers) || Modifier.isFinal(modifiers);
    }
}

