package cn.minsin.core.tools;

/**
 * emoji表情过滤
 * 
 * @author mintonzhang 2018年7月27日
 */
public class EmojiFilter {

	public static boolean containsEmoji(String source) {
		if(StringUtil.isBlank(source)) {
			return false;
		}
		return source.matches("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]");
	}

	/**
	 * 过滤emoji 或者 其他非文字类型的字符
	 * 
	 * @param source
	 * @return
	 */
	public static String filterEmoji(String source) {
		if(StringUtil.isBlank(source)) {
			return source;
		}
		return source.replaceAll("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]", "");
	}

}
