/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.web;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.web.DefaultResultOptions;
import cn.minsin.core.web.ResultOptions;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.HashMap;

public class Result
implements Serializable {
    private static final long serialVersionUID = -8603085056620027210L;
    private int code;
    private String msg;
    private Object data;
    private HashMap<String, Object> multidata = new HashMap();

    protected Result() {
    }

    protected Result(ResultOptions options, String ... msg) {
        this.validateOption(options);
        String rmsg = options.getMsg();
        if (msg != null && msg.length > 0) {
            rmsg = msg[0];
        }
        this.code = options.getCode();
        this.msg = rmsg;
    }

    public HashMap<String, Object> getMultidata() {
        return this.multidata;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public Object getData() {
        return this.data;
    }

    public Result resetOption(ResultOptions option, String ... msg) {
        this.validateOption(option);
        String rmsg = option.getMsg();
        if (msg != null && msg.length > 0) {
            rmsg = msg[0];
        }
        this.code = option.getCode();
        this.msg = rmsg;
        return this;
    }

    public Result data(String key, Object value) {
        this.multidata.put(key, value);
        return this;
    }

    public Result data(Object value) {
        this.data = value;
        return this;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public static Result builder(ResultOptions option, String ... message) {
        return new Result(option, message);
    }

    public static Result builderSuccess(String ... msg) {
        return new Result(DefaultResultOptions.SUCCESS, msg);
    }

    public static Result builderException(String ... msg) {
        return new Result(DefaultResultOptions.EXCEPTION, msg);
    }

    public static Result builderMissParamter(String ... msg) {
        return new Result(DefaultResultOptions.MISSPARAMTER, msg);
    }

    public static Result builderFail(String ... msg) {
        return new Result(DefaultResultOptions.FAIL, msg);
    }

    public static Result builderOutTime(String ... msg) {
        return new Result(DefaultResultOptions.OUTTIME, msg);
    }

    private void validateOption(ResultOptions option) {
        if (option == null || !option.getClass().isEnum()) {
            throw new MutilsException("ResultOptions must be an enumeration and implement ResultOptions.");
        }
    }
}

