/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.init.core;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.init.core.MutilsFunctions;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InitConfig {
    protected static Logger slog = LoggerFactory.getLogger(InitConfig.class);
    private static final Set<InitConfig> starters = new HashSet<InitConfig>();
    private static final Map<Type, InitConfig> loadedConfig = new HashMap<Type, InitConfig>();
    private static boolean isInit = false;

    protected InitConfig() {
        starters.add(this);
    }

    public static void init(MutilsFunctions[] functions) {
        if (isInit) {
            slog.error("The function has been initialized and the initialization failed.");
            return;
        }
        isInit = true;
        if (functions == null) {
            slog.info("Function initialized failed, Please check config.");
            return;
        }
        slog.info("The selected function is about to be initialized.");
        for (MutilsFunctions mutilsFunctions : functions) {
            Class<? extends InitConfig> clazz = mutilsFunctions.getClazz();
            for (InitConfig config : starters) {
                Class<?> class1 = config.getClass();
                if (!clazz.equals(class1)) continue;
                String artifactId = mutilsFunctions.getArtifactId();
                config.checkConfig();
                loadedConfig.put(class1, config);
                slog.info("{} initialized successfully.", (Object)artifactId);
            }
        }
    }

    protected abstract void checkConfig();

    public static <T extends InitConfig> T loadConfig(Class<T> configClazz) {
        if (configClazz == null || !loadedConfig.containsKey(configClazz)) {
            throw new MutilsException("Cant't find Configuation of " + configClazz.getName() + " ,Maybe The configuration file is not initialized or empty, please check the configuration file or select functions.");
        }
        return (T)loadedConfig.get(configClazz);
    }
}

