/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.init;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.init.core.InitConfig;
import cn.minsin.core.tools.StringUtil;

public class WechatPayCoreConfig
extends InitConfig {
    private String partnerId;
    private String partnerKey;
    private String refundUrl = "https://api.mch.weixin.qq.com/secapi/pay/refund";
    private String notifyUrl;
    private String refundNotifyUrl;
    private String certificatePath;
    private String unifiedOrderUrl = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private String certificateFormat = "PKCS12";
    private boolean withRefund = false;
    private String withdrawUrl = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";
    private boolean isSynchronizeRefund = true;

    public boolean isSynchronizeRefund() {
        return this.isSynchronizeRefund;
    }

    public void setSynchronizeRefund(boolean isSynchronizeRefund) {
        this.isSynchronizeRefund = isSynchronizeRefund;
    }

    public String getRefundNotifyUrl() {
        return this.refundNotifyUrl;
    }

    public void setRefundNotifyUrl(String refundNotifyUrl) {
        this.refundNotifyUrl = refundNotifyUrl;
    }

    public boolean isWithRefund() {
        return this.withRefund;
    }

    public String getWithdrawUrl() {
        return this.withdrawUrl;
    }

    public void setWithdrawUrl(String withdrawUrl) {
        this.withdrawUrl = withdrawUrl;
    }

    public void setWithRefund(boolean withRefund) {
        this.withRefund = withRefund;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getPartnerKey() {
        return this.partnerKey;
    }

    public void setPartnerKey(String partnerKey) {
        this.partnerKey = partnerKey;
    }

    public String getRefundUrl() {
        return this.refundUrl;
    }

    public void setRefundUrl(String refundUrl) {
        this.refundUrl = refundUrl;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public String getUnifiedOrderUrl() {
        return this.unifiedOrderUrl;
    }

    public void setUnifiedOrderUrl(String unifiedOrderUrl) {
        this.unifiedOrderUrl = unifiedOrderUrl;
    }

    public String getCertificateFormat() {
        return this.certificateFormat;
    }

    public void setCertificateFormat(String certificateFormat) {
        this.certificateFormat = certificateFormat;
    }

    @Override
    protected void checkConfig() {
        slog.info("Required for initialization partnerId,partnerKey,notifyUrl,unifiedOrderUrl.When withRefund is true,You also need certificatePath, refundUrl, certificateFormat,refundNotifyUrl");
        if (StringUtil.isBlank(this.partnerId, this.partnerKey, this.notifyUrl, this.unifiedOrderUrl)) {
            throw new MutilsException("An error when initialization the basic config for wechat pay, please check config");
        }
        if (this.withRefund) {
            if (StringUtil.isBlank(this.certificatePath, this.refundUrl, this.certificateFormat)) {
                throw new MutilsException("The refund config of wechat pay was initialization failed.");
            }
            if (!this.isSynchronizeRefund && StringUtil.isBlank((CharSequence)this.refundNotifyUrl)) {
                throw new MutilsException("RefundNotifyUrl  cannot be empty.");
            }
        }
    }
}

