/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Page<E>
implements Serializable {
    private static final long serialVersionUID = -5796659299635955253L;
    private int code = 0;
    private String msg = "\u8bf7\u6c42\u6210\u529f";
    private long count;
    private List<E> data;
    private long totalpage;
    private long nowpage;

    public long getTotalpage() {
        return this.totalpage;
    }

    public void setTotalpage(long totalpage) {
        this.totalpage = totalpage;
    }

    public long getNowpage() {
        return this.nowpage;
    }

    public void setNowpage(long nowpage) {
        this.nowpage = nowpage;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public List<E> getData() {
        return this.data;
    }

    public void setData(List<E> data) {
        this.data = data;
    }

    public Page(int count, List<E> data, int nowpage, int limit) {
        this.count = count;
        this.data = data;
        this.nowpage = nowpage;
        this.totalpage = Page.getMaxPage(count, limit);
    }

    public static int checkPage(Integer page, int def) {
        return page == null || page < 1 ? def : page;
    }

    public static int checkLimit(Integer limit, int def) {
        return limit == null || limit < 1 ? def : limit;
    }

    public static int getStartIndex(Integer page, Integer limit, int def) {
        page = Page.checkPage(page, 1);
        limit = Page.checkLimit(limit, 10);
        return (page - 1) * limit < 0 ? def : (page - 1) * limit;
    }

    public static int getMaxPage(int total, int limit) {
        return total % limit == 0 ? total / limit : total / limit + 1;
    }

    public static <T> List<T> getList(List<T> list, Integer page, Integer limit) {
        try {
            int size = list.size();
            if (size < limit) {
                return list;
            }
            if (page * limit > size) {
                return new ArrayList<T>(list.subList((page - 1) * limit, size));
            }
            return new ArrayList<T>(list.subList((page - 1) * limit, limit * page));
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    public String toString() {
        return "Page [code=" + this.code + ", msg=" + this.msg + ", count=" + this.count + ", data=" + this.data + "]";
    }
}

