/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    private static final String[] keys = new String[]{"undefined", "null"};

    public static boolean isBlank(Object ... param) {
        if (param == null || param.length == 0) {
            return false;
        }
        for (Object object : param) {
            if (object != null && !"".equals(object) && object.toString().length() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(Object ... param) {
        if (param == null || param.length == 0) {
            return false;
        }
        for (Object object : param) {
            if (object == null || "".equals(object) || object.toString().length() < 0) continue;
            return true;
        }
        return false;
    }

    public static final String filterSearchKey(String str, String ... filterKey) {
        str = StringUtil.filterSpace(str);
        if (filterKey != null && filterKey.length > 0 && str != null) {
            for (String string : filterKey) {
                if (!string.equals(str)) continue;
                return null;
            }
        }
        return str;
    }

    public static final String filterSpace(String str) {
        str = StringUtils.isBlank((CharSequence)str) ? null : str.trim();
        for (String key : keys) {
            if (!key.equals(str)) continue;
            return null;
        }
        return str;
    }

    public static final String filterAllSpace(String str) {
        return StringUtil.filterSpace(str) == null ? null : str.replace(" ", "");
    }

    public static final String likeSearch(String key, Integer type) {
        if ((key = StringUtil.filterSearchKey(key, new String[0])) != null) {
            return type == -1 ? "%" + key : (type == 1 ? key + "%" : "%" + key + "%");
        }
        return null;
    }

    public static final String likeSearch(String key, String filterKey, Integer type) {
        if ((key = StringUtil.filterSearchKey(key, filterKey)) != null) {
            return type == -1 ? "%" + key : (type == 1 ? key + "%" : "%" + key + "%");
        }
        return null;
    }

    public static final String getUUIDForLength(int length) {
        if (length < 1 || length > 32) {
            length = 32;
        }
        return UUID.randomUUID().toString().replace("-", "").toUpperCase().substring(0, length);
    }

    public static final String replaceSemicolonToEnglish(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return null;
        }
        return str.replace("\uff1b", ";");
    }

    public static final String replaceColonToEnglish(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return null;
        }
        return str.replace("\uff1a", ":");
    }

    public static final boolean checkStringLength(String str, int length, boolean allowNull) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return !allowNull;
        }
        return str.length() > length;
    }

    public static String relaceUnderline(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return "";
        }
        CharSequence[] split = str.split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtil.firstCharacterToUpper((String)split[i]);
        }
        return String.join((CharSequence)"", split);
    }

    public static String relaceUnderline(String[] str) {
        for (int i = 0; i < str.length; ++i) {
            str[i] = StringUtil.firstCharacterToUpper(str[i]);
        }
        return String.join((CharSequence)"", str);
    }

    public static String firstCharacterToUpper(String srcStr) {
        return srcStr.substring(0, 1).toUpperCase() + srcStr.substring(1);
    }

    public static String removeFormat(String str) {
        if ((str = StringUtil.filterAllSpace(str)) == null) {
            return null;
        }
        return str.replace("\r", "").replace("\n", "").replace("\t", "");
    }

    public static boolean isContainChinese(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern p = Pattern.compile("[\u4e00-\u9fa5|\\\uff01|\\\uff0c|\\\u3002|\\\uff08|\\\uff09|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\uff1f|\\\uff1a|\\\uff1b|\\\u3010|\\\u3011]");
        Matcher m = p.matcher(str);
        return m.find();
    }
}

