/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools.date;

import cn.minsin.core.tools.ListUtil;
import cn.minsin.core.tools.date.DateUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;

public class LunarUtil {
    private static final long[] lunarInfo = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42448L, 83315L, 21200L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46496L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19415L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L};
    private static final String[] nStr1 = new String[]{"\u6b63\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u51ac\u6708", "\u814a\u6708"};
    private static final String[] gan = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] zhi = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] animals = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    private static final String[] solarTerms = new String[]{"\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3"};
    private static final String[] holidays = new String[]{"0101*\u5143\u65e6", "0214\u60c5\u4eba\u8282", "0308\u5987\u5973\u8282", "0312\u690d\u6811\u8282", "0315\u6d88\u8d39\u8005\u6743\u76ca\u65e5", "0401\u611a\u4eba\u8282", "0501\u52b3\u52a8\u8282", "0504\u9752\u5e74\u8282", "0512\u62a4\u58eb\u8282", "0601\u513f\u7ae5\u8282", "0701\u5efa\u515a\u8282", "0801\u5efa\u519b\u8282", "0808\u7236\u4eb2\u8282", "0909\u6bdb\u6cfd\u4e1c\u901d\u4e16\u7eaa\u5ff5", "0910\u6559\u5e08\u8282", "0928\u5b54\u5b50\u8bde\u8fb0", "1001*\u56fd\u5e86\u8282", "1006\u8001\u4eba\u8282", "1024\u8054\u5408\u56fd\u65e5", "1112\u5b59\u4e2d\u5c71\u8bde\u8fb0", "1220\u6fb3\u95e8\u56de\u5f52", "1225\u5723\u8bde\u8282", "1226\u6bdb\u6cfd\u4e1c\u8bde\u8fb0"};
    private static final String[] nlHoldays = new String[]{"0101*\u519c\u5386\u6625\u8282", "0115\u5143\u5bb5\u8282", "0505\u7aef\u5348\u8282", "0707\u4e03\u5915\u60c5\u4eba\u8282", "0815\u4e2d\u79cb\u8282", "0909\u91cd\u9633\u8282", "1208\u814a\u516b\u8282", "1224\u5c0f\u5e74", "0100*\u9664\u5915"};
    private static final long[] sTermInfo = new long[]{0L, 21208L, 42467L, 63836L, 85337L, 107014L, 128867L, 150921L, 173149L, 195551L, 218072L, 240693L, 263343L, 285989L, 308563L, 331033L, 353350L, 375494L, 397447L, 419210L, 440795L, 462224L, 483532L, 504758L};
    private static Calendar offDate = Calendar.getInstance();

    protected LunarUtil() {
    }

    private static final int lYearDays(int y) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((lunarInfo[y - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + LunarUtil.leapDays(y);
    }

    private static final int leapDays(int y) {
        if (LunarUtil.leapMonth(y) != 0) {
            if ((lunarInfo[y - 1900] & 0x10000L) != 0L) {
                return 30;
            }
            return 29;
        }
        return 0;
    }

    private static final int leapMonth(int y) {
        return (int)(lunarInfo[y - 1900] & 0xFL);
    }

    private static final int monthDays(int y, int m) {
        if ((lunarInfo[y - 1900] & (long)(65536 >> m)) == 0L) {
            return 29;
        }
        return 30;
    }

    private static final String AnimalsYear(int y) {
        return animals[(y - 4) % 12];
    }

    private static final String cyclicalm(int num) {
        return gan[num % 10] + zhi[num % 12];
    }

    private static final String cyclical(int y) {
        int num = y - 1900 + 36;
        return LunarUtil.cyclicalm(num);
    }

    private static final int[] calElement(int y, int m, int d) {
        int[] nongDate = new int[7];
        int i = 0;
        int temp = 0;
        int leap = 0;
        Date baseDate = new GregorianCalendar(1900, 0, 31).getTime();
        Date objDate = new GregorianCalendar(y, m - 1, d).getTime();
        int offset = (int)((objDate.getTime() - baseDate.getTime()) / 86400000L);
        nongDate[5] = offset + 40;
        nongDate[4] = 14;
        for (i = 1900; i < 2050 && offset > 0; offset -= temp, ++i) {
            temp = LunarUtil.lYearDays(i);
            nongDate[4] = nongDate[4] + 12;
        }
        if (offset < 0) {
            offset += temp;
            nongDate[4] = nongDate[4] - 12;
        }
        nongDate[0] = --i;
        nongDate[3] = i - 1864;
        leap = LunarUtil.leapMonth(i);
        nongDate[6] = 0;
        for (i = 1; i < 13 && offset > 0; ++i) {
            if (leap > 0 && i == leap + 1 && nongDate[6] == 0) {
                --i;
                nongDate[6] = 1;
                temp = LunarUtil.leapDays(nongDate[0]);
            } else {
                temp = LunarUtil.monthDays(nongDate[0], i);
            }
            if (nongDate[6] == 1 && i == leap + 1) {
                nongDate[6] = 0;
            }
            offset -= temp;
            if (nongDate[6] != 0) continue;
            nongDate[4] = nongDate[4] + 1;
        }
        if (offset == 0 && leap > 0 && i == leap + 1) {
            if (nongDate[6] == 1) {
                nongDate[6] = 0;
            } else {
                nongDate[6] = 1;
                --i;
                nongDate[4] = nongDate[4] - 1;
            }
        }
        if (offset < 0) {
            offset += temp;
            nongDate[4] = nongDate[4] - 1;
        }
        nongDate[1] = --i;
        nongDate[2] = offset + 1;
        return nongDate;
    }

    private static final String getChinaDate(int day) {
        String a = "";
        if (day == 10) {
            return "\u521d\u5341";
        }
        if (day == 20) {
            return "\u4e8c\u5341";
        }
        if (day == 30) {
            return "\u4e09\u5341";
        }
        int two = day / 10;
        if (two == 0) {
            a = "\u521d";
        }
        if (two == 1) {
            a = "\u5341";
        }
        if (two == 2) {
            a = "\u5eff";
        }
        if (two == 3) {
            a = "\u4e09";
        }
        int one = day % 10;
        switch (one) {
            case 1: {
                a = a + "\u4e00";
                break;
            }
            case 2: {
                a = a + "\u4e8c";
                break;
            }
            case 3: {
                a = a + "\u4e09";
                break;
            }
            case 4: {
                a = a + "\u56db";
                break;
            }
            case 5: {
                a = a + "\u4e94";
                break;
            }
            case 6: {
                a = a + "\u516d";
                break;
            }
            case 7: {
                a = a + "\u4e03";
                break;
            }
            case 8: {
                a = a + "\u516b";
                break;
            }
            case 9: {
                a = a + "\u4e5d";
            }
        }
        return a;
    }

    private static final String getSolarTerms(Date date) {
        offDate.setTime(date);
        int y = offDate.get(1);
        int m = offDate.get(2) + 1;
        int d = offDate.get(5);
        if (d == LunarUtil.sTerm(y, (m - 1) * 2)) {
            return solarTerms[(m - 1) * 2];
        }
        if (d == LunarUtil.sTerm(y, (m - 1) * 2 + 1)) {
            return solarTerms[(m - 1) * 2 + 1];
        }
        return "";
    }

    private static final int sTerm(int y, int n) {
        offDate.set(1900, 0, 6, 2, 5, 0);
        long temp = offDate.getTime().getTime();
        offDate.setTime(new Date((long)(3.15569259747E10 * (double)(y - 1900) + (double)(sTermInfo[n] * 60000L) + (double)temp)));
        return offDate.get(5);
    }

    private static List<String> getHoliday(Date date, int[] l) {
        String date2String = DateUtil.date2String(date, () -> "MMdd");
        ArrayList<String> list = ListUtil.newArrayList();
        for (String string : holidays) {
            if (!string.contains(date2String)) continue;
            list.add(string.replace(date2String, ""));
        }
        for (String string : nlHoldays) {
            date2String = String.format("%02d", l[1]) + String.format("%02d", l[2]);
            if (!string.contains(date2String)) continue;
            list.add(string.replace(date2String, ""));
        }
        return list;
    }

    public static LunarModel getLunarDate(int year, int month, int day) {
        Calendar today = Calendar.getInstance(Locale.SIMPLIFIED_CHINESE);
        today.set(year, month - 1, day);
        int[] l = LunarUtil.calElement(year, month, day);
        Date time = today.getTime();
        LunarModel model = new LunarModel();
        model.setLunarYearAnimal(LunarUtil.AnimalsYear(year));
        model.setDate(time);
        model.setHoliday(LunarUtil.getHoliday(time, l));
        model.setSolarStr(LunarUtil.getSolarTerms(time));
        model.setLunarYear(LunarUtil.cyclical(year));
        model.setLunarMonth(nStr1[l[1]]);
        model.setLunarDate(LunarUtil.getChinaDate(l[2]));
        model.setWeek(DateUtil.date2String(time, () -> "E"));
        return model;
    }

    public static LunarModel getLunarDate(Date date) {
        offDate.setTime(date);
        int y = offDate.get(1);
        int m = offDate.get(2) + 1;
        int d = offDate.get(5);
        return LunarUtil.getLunarDate(y, m, d);
    }

    public static class LunarModel {
        private Date date;
        private String week;
        private String lunarYear;
        private String lunarMonth;
        private String lunarDate;
        private String solarStr;
        private List<String> holiday;
        private String lunarYearAnimal;

        public String getLunarMonth() {
            return this.lunarMonth;
        }

        public void setLunarMonth(String lunarMonth) {
            this.lunarMonth = lunarMonth;
        }

        public String getLunarDate() {
            return this.lunarDate;
        }

        public void setLunarDate(String lunarDate) {
            this.lunarDate = lunarDate;
        }

        public String getLunarYear() {
            return this.lunarYear;
        }

        public void setLunarYear(String lunarYear) {
            this.lunarYear = lunarYear;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public String getWeek() {
            return this.week;
        }

        public void setWeek(String week) {
            this.week = week;
        }

        public String getSolarStr() {
            return this.solarStr;
        }

        public void setSolarStr(String solarStr) {
            this.solarStr = solarStr;
        }

        public List<String> getHoliday() {
            return this.holiday;
        }

        public void setHoliday(List<String> holiday) {
            this.holiday = holiday;
        }

        public String getLunarYearAnimal() {
            return this.lunarYearAnimal;
        }

        public void setLunarYearAnimal(String lunarYearAnimal) {
            this.lunarYearAnimal = lunarYearAnimal;
        }

        public String toString() {
            return "[date=" + this.date + ", week=" + this.week + ", lunarYear=" + this.lunarYear + ", lunarMonth=" + this.lunarMonth + ", lunarDate=" + this.lunarDate + ", solarStr=" + this.solarStr + ", holiday=" + this.holiday + ", animal=" + this.lunarYearAnimal + "]";
        }
    }
}

