/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools;

import cn.minsin.core.annotation.Ignore;
import cn.minsin.core.annotation.NotNull;
import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.tools.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class ModelUtil {
    private static final String ERROR_MESSAGE_TEMPLATE = " '%s' Can't be empty,model field means '%s'";

    protected ModelUtil() {
    }

    public static <T> SortedMap<String, String> toTreeMap(T model) {
        TreeMap<String, String> tree = new TreeMap<String, String>();
        for (Field field : ModelUtil.getAllFieldsAndFilter(model)) {
            ParseFiled parseFiled = ModelUtil.parseFiled(field, model);
            if (parseFiled == null) continue;
            tree.put(parseFiled.getKey(), parseFiled.getStringValue());
        }
        return tree;
    }

    public static <T> Set<Field> getAllFields(T model) {
        return ModelUtil.getAllFields(model.getClass());
    }

    public static Set<Field> getAllFields(Class<?> model) {
        HashSet<Field> fieldSet = new HashSet<Field>();
        Class<?> superClass = model.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            while (superClass != null) {
                Field[] fields = superClass.getDeclaredFields();
                fieldSet.addAll(Arrays.asList(fields));
                superClass = superClass.getSuperclass();
            }
        }
        Field[] declaredFields = model.getDeclaredFields();
        fieldSet.addAll(Arrays.asList(declaredFields));
        return fieldSet;
    }

    public static <T> Set<Field> getAllFieldsAndFilter(T model) {
        Set<Field> allFields = ModelUtil.getAllFields(model);
        allFields.removeIf(ModelUtil::verificationField);
        return allFields;
    }

    public static <T> void verificationField(T model) throws MutilsException {
        for (Field field : ModelUtil.getAllFieldsAndFilter(model)) {
            ModelUtil.parseFiled(field, model);
        }
    }

    public static boolean verificationField(Field field) {
        int modifiers = field.getModifiers();
        Ignore ignore = field.getAnnotation(Ignore.class);
        return Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers) || Modifier.isNative(modifiers) || !Modifier.isPrivate(modifiers) || ignore != null;
    }

    public static <T> ParseFiled parseFiled(Field field, T model) {
        ParseFiled parseFiled = new ParseFiled();
        try {
            NotNull annotation = field.getAnnotation(NotNull.class);
            String key = annotation.key();
            if (StringUtil.isBlank((CharSequence)key)) {
                key = field.getName();
            }
            field.setAccessible(true);
            Object object = field.get(model);
            if (object == null) {
                if (annotation.notNull()) {
                    String description = annotation.value();
                    throw new MutilsException(String.format(ERROR_MESSAGE_TEMPLATE, key, description));
                }
                return null;
            }
            parseFiled.setData(object, key);
            return parseFiled;
        }
        catch (Exception e) {
            throw new MutilsException(e);
        }
    }

    public static class ParseFiled {
        private Object value;
        private String key;

        public String getStringValue() {
            return this.value != null ? this.value.toString() : null;
        }

        void setData(Object value, String key) {
            this.value = value;
            this.key = key;
        }

        public Object getValue() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }
    }
}

