/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.init;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public abstract class AbstractConfig {
    @NestedConfigurationProperty
    protected static final Logger slog = LoggerFactory.getLogger(AbstractConfig.class);
    @NestedConfigurationProperty
    private static final Map<Type, AbstractConfig> localProperties = new ConcurrentHashMap<Type, AbstractConfig>();

    public static void init(Class<?> configClazz, AbstractConfig config) {
        config.checkConfig();
        localProperties.put(configClazz, config);
    }

    public static <T extends AbstractConfig> T loadConfig(Class<T> configClazz) {
        if (configClazz == null || !localProperties.containsKey(configClazz)) {
            return null;
        }
        return (T)localProperties.get(configClazz);
    }

    protected abstract void checkConfig();
}

