package cn.minsin.core.tools;

import java.awt.*;

/**
 * @author: minton.zhang
 * @since: 2019/12/6 14:37
 * 0.1.2.RELEASE
 */
public class ColorUtil {

    /**
     * 16进制字符串转换成颜色
     *
     * @param binary16String 16 进制颜色字符串
     */
    public static Color binary16ToColor(String binary16String) {
        int length = binary16String.length();
        //需要处理一下那些缩写的，例如#ff0，我们要将他转为#ffff00
        if (length <= 4) {
            char c1 = binary16String.charAt(1);
            char c2 = binary16String.charAt(2);
            char c3 = binary16String.charAt(3);
            binary16String = "#" + c1 + c1 + c2 + c2 + c3 + c3;
        }
        String str1 = binary16String.substring(1, 3);
        String str2 = binary16String.substring(3, 5);
        String str3 = binary16String.substring(5, 7);
        int red = Integer.parseInt(str1, 16);
        int green = Integer.parseInt(str2, 16);
        int blue = Integer.parseInt(str3, 16);
        return new Color(red, green, blue);
    }
}
