/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools.date;

import cn.minsin.core.tools.date.DateFormat;
import cn.minsin.core.tools.date.DefaultDateFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends DateUtils {
    private static Calendar calendar = Calendar.getInstance();

    protected DateUtil() {
    }

    public static String date2String(Date date) {
        return DateUtil.date2String(date, DefaultDateFormat.yyyy_MM_dd_HH_mm_ss);
    }

    public static String date2String(Date date, DateFormat format) {
        return DateFormatUtils.format((Date)date, (String)format.getFormat());
    }

    public static String date2String(Date date, DateFormat format, String defaultValue) {
        try {
            return DateUtil.date2String(date, format);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String long2DateStr(long source) {
        return DateUtil.long2DateStr(source, DefaultDateFormat.yyyy_MM_dd_HH_mm_ss);
    }

    public static String long2DateStr(long source, DateFormat format) {
        return DateFormatUtils.format((Date)new Date(source), (String)format.getFormat());
    }

    public static String long2DateStr(long source, DateFormat format, String defaultValue) {
        try {
            return DateUtil.long2DateStr(source, format);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Date long2Date(long source) {
        return new Date(source);
    }

    public static Date string2Date(String source, DateFormat format) {
        try {
            return DateUtils.parseDate((String)source, (String[])new String[]{format.getFormat()});
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getBeginOfDay(Date date) {
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getBeginOfDay(String dateStr, DateFormat dateEnum) {
        Date date = DateUtil.string2Date(dateStr, dateEnum);
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getEndOfDay(String dateStr, DateFormat dateEnum) {
        Date date = DateUtil.string2Date(dateStr, dateEnum);
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date createDate(int year, int month, int dayOfMonth) {
        LocalDate of = LocalDate.of(year, month, dayOfMonth);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = of.atStartOfDay().atZone(zone).toInstant();
        return Date.from(instant);
    }
}

