/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools.area;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.tools.HttpClientUtil;
import cn.minsin.core.tools.ListUtil;
import cn.minsin.core.tools.area.AreaModel;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChinaAreaUtil {
    private static final Logger log = LoggerFactory.getLogger(ChinaAreaUtil.class);
    private static String remoteUrl = "http://datavmap-public.oss-cn-hangzhou.aliyuncs.com/areas/csv/";
    private static String defaultProvinceCode = "100000";
    private static String province = "${code}_province.json";
    private static String city = "${code}_city.json";
    private static String district = "${code}_district.json";
    private static String placeholder = "${code}";
    private CloseableHttpClient client = HttpClientUtil.getInstance();

    private ChinaAreaUtil() {
    }

    public static ChinaAreaUtil init() {
        return new ChinaAreaUtil();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AreaModel> initProvince() throws MutilsErrorException {
        HttpGet getMethod = HttpClientUtil.getGetMethod(remoteUrl + province.replace(placeholder, defaultProvinceCode));
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod);){
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            JSONObject parseObject = JSON.parseObject((String)jsonStr);
            Object object = parseObject.get((Object)"rows");
            List list = JSON.parseArray((String)object.toString(), AreaModel.class);
            return list;
        }
        catch (Exception e) {
            throw new MutilsErrorException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AreaModel> initCity(String provinceCode) throws MutilsErrorException {
        HttpGet getMethod = HttpClientUtil.getGetMethod(remoteUrl + city.replace(placeholder, provinceCode));
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod);){
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            JSONObject parseObject = JSON.parseObject((String)jsonStr);
            Object object = parseObject.get((Object)"rows");
            List list = JSON.parseArray((String)object.toString(), AreaModel.class);
            return list;
        }
        catch (Exception e) {
            throw new MutilsErrorException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AreaModel> initDistrict(String cityCode) throws MutilsErrorException {
        HttpGet getMethod = HttpClientUtil.getGetMethod(remoteUrl + district.replace(placeholder, cityCode));
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod);){
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            JSONObject parseObject = JSON.parseObject((String)jsonStr);
            Object object = parseObject.get((Object)"rows");
            List list = JSON.parseArray((String)object.toString(), AreaModel.class);
            return list;
        }
        catch (Exception e) {
            throw new MutilsErrorException(e);
        }
    }

    public List<AreaModel> initProvinceWithChildren() throws MutilsErrorException {
        List<AreaModel> initProvince = this.initProvince();
        for (AreaModel province : initProvince) {
            List<AreaModel> initCity = this.initCity(province.getAdcode());
            for (AreaModel city : initCity) {
                try {
                    List<AreaModel> initDistrict = this.initDistrict(city.getAdcode());
                    for (AreaModel temp : initDistrict) {
                        if (!temp.getParent().equals(city.getName())) continue;
                        city.setChild(temp);
                    }
                    if (!ListUtil.isEmpty(city.getChildren())) continue;
                    log.error("adcode\u4e3a\uff1a{},name\u4e3a{}\uff0c\u6ca1\u6709Children.", (Object)city.getAdcode(), (Object)city.getName());
                }
                catch (Exception e) {
                    log.error("adcode\u4e3a\uff1a{},name\u4e3a{}\uff0c\u4e22\u5931\u6570\u636e,\u5df2\u8df3\u8fc7.", (Object)city.getAdcode(), (Object)city.getName());
                }
            }
            province.setChildren(initCity);
        }
        return initProvince;
    }
}

