/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;

public class NumberUtil
extends NumberUtils {
    protected NumberUtil() {
    }

    public static boolean isNumbers(String ... str) {
        try {
            for (String string : str) {
                if (NumberUtils.isCreatable((String)string)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T extends Number> boolean isNumbers(Class<T> type, String ... str) {
        try {
            Method method = type.getMethod("valueOf", String.class);
            for (String string : str) {
                method.invoke(type, string);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static BigDecimal decimalsXLength(int length, BigDecimal old) {
        if (length < 0 || old == null) {
            return old;
        }
        return old.setScale(length, 4);
    }

    public static <T extends Number> BigDecimal add(T a, T b, int decimal) {
        if (a != null && b != null) {
            return NumberUtil.decimalsXLength(2, BigDecimal.valueOf(a.doubleValue())).add(BigDecimal.valueOf(b.doubleValue())).setScale(decimal);
        }
        return BigDecimal.valueOf(0L);
    }

    public static <T extends Number> BigDecimal subtract(T a, T b, int decimal) {
        if (a != null && b != null) {
            return NumberUtil.decimalsXLength(2, BigDecimal.valueOf(a.doubleValue())).subtract(BigDecimal.valueOf(b.doubleValue())).setScale(decimal);
        }
        return BigDecimal.valueOf(0L);
    }

    public static <T extends Number> BigDecimal divide(T a, T b, int decimal) {
        if (a != null && b != null) {
            return NumberUtil.decimalsXLength(2, BigDecimal.valueOf(a.doubleValue())).divide(BigDecimal.valueOf(b.doubleValue()), decimal, RoundingMode.HALF_UP).setScale(decimal);
        }
        return BigDecimal.valueOf(0L);
    }

    public static <T extends Number> BigDecimal multiply(T a, T b, int decimal) {
        if (a != null && b != null) {
            return NumberUtil.decimalsXLength(2, BigDecimal.valueOf(a.doubleValue())).multiply(BigDecimal.valueOf(b.doubleValue())).setScale(decimal);
        }
        return BigDecimal.valueOf(0L);
    }

    public static <T extends Number> BigDecimal remainder(T a, T b, int decimal) {
        if (a != null && b != null) {
            return NumberUtil.decimalsXLength(2, BigDecimal.valueOf(a.doubleValue())).remainder(BigDecimal.valueOf(b.doubleValue())).setScale(decimal);
        }
        return BigDecimal.valueOf(0L);
    }
}

