/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools.area;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.tools.HttpClientUtil;
import cn.minsin.core.tools.IOUtil;
import cn.minsin.core.tools.area.AreaInit;
import cn.minsin.core.tools.area.AreaModel;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChinaAreaUtil {
    protected static Logger slog = LoggerFactory.getLogger(ChinaAreaUtil.class);
    private AreaInit init;
    private CloseableHttpClient client;

    private ChinaAreaUtil(AreaInit init) {
        this.init = init == null ? new AreaInit() : init;
        this.client = HttpClientUtil.getInstance();
    }

    public static ChinaAreaUtil init() {
        return new ChinaAreaUtil(null);
    }

    public List<AreaModel> initProvince() throws MutilsErrorException {
        List list;
        CloseableHttpResponse response = null;
        try {
            HttpGet getMethod = HttpClientUtil.getGetMethod(this.init.getRemoteUrl() + this.init.getProvince().replace(this.init.getPlaceholder(), this.init.getDefaultProvinceCode()));
            response = this.client.execute((HttpUriRequest)getMethod);
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            JSONObject parseObject = JSON.parseObject((String)jsonStr);
            Object object = parseObject.get((Object)"rows");
            list = JSON.parseArray((String)object.toString(), AreaModel.class);
        }
        catch (Exception e) {
            try {
                throw new MutilsErrorException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(response);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)response);
        return list;
    }

    public List<AreaModel> initCity(String provinceCode) throws MutilsErrorException {
        List list;
        CloseableHttpResponse response = null;
        try {
            HttpGet getMethod = HttpClientUtil.getGetMethod(this.init.getRemoteUrl() + this.init.getCity().replace(this.init.getPlaceholder(), provinceCode));
            response = this.client.execute((HttpUriRequest)getMethod);
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            JSONObject parseObject = JSON.parseObject((String)jsonStr);
            Object object = parseObject.get((Object)"rows");
            list = JSON.parseArray((String)object.toString(), AreaModel.class);
        }
        catch (Exception e) {
            try {
                throw new MutilsErrorException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(response);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)response);
        return list;
    }

    public List<AreaModel> initDistrict(String cityCode) throws MutilsErrorException {
        List list;
        CloseableHttpResponse response = null;
        try {
            HttpGet getMethod = HttpClientUtil.getGetMethod(this.init.getRemoteUrl() + this.init.getDistrict().replace(this.init.getPlaceholder(), cityCode));
            response = this.client.execute((HttpUriRequest)getMethod);
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            JSONObject parseObject = JSON.parseObject((String)jsonStr);
            Object object = parseObject.get((Object)"rows");
            list = JSON.parseArray((String)object.toString(), AreaModel.class);
        }
        catch (Exception e) {
            try {
                throw new MutilsErrorException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(response);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)response);
        return list;
    }

    public List<AreaModel> initProvinceWithChildren() throws MutilsErrorException {
        List<AreaModel> initProvince = this.initProvince();
        for (AreaModel province : initProvince) {
            List<AreaModel> initCity = this.initCity(province.getAdcode());
            for (AreaModel city : initCity) {
                try {
                    List<AreaModel> initDistrict = this.initDistrict(city.getAdcode());
                    city.setChildren(initDistrict);
                }
                catch (Exception e) {
                    slog.error("adcode\u4e3a\uff1a{},name\u4e3a{}\uff0c\u4e22\u5931\u6570\u636e,\u5df2\u8df3\u8fc7.", (Object)city.getAdcode(), (Object)city.getName());
                }
            }
            province.setChildren(initCity);
        }
        return initProvince;
    }
}

