/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools;

import cn.minsin.core.tools.ArrayUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    private static String[] keys = new String[]{"undefined", "null"};
    static Pattern p = Pattern.compile("[\u4e00-\u9fa5|\\\uff01|\\\uff0c|\\\u3002|\\\uff08|\\\uff09|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\uff1f|\\\uff1a|\\\uff1b|\\\u3010|\\\u3011]");

    public static boolean isBlank(Object ... param) {
        try {
            for (Object object : param) {
                Method declaredMethod;
                Object invoke;
                if (object == null || StringUtil.isBlank((CharSequence)object.toString())) {
                    return true;
                }
                if (!(object instanceof Collection) && !(object instanceof Map) || !"true".equals((invoke = (declaredMethod = object.getClass().getDeclaredMethod("isEmpty", new Class[0])).invoke(object, new Object[0])).toString())) continue;
                return true;
            }
            return param.length == 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String isBlankWithDefault(String cs, String def) {
        return StringUtil.isBlank((CharSequence)cs) ? def : cs;
    }

    public static boolean isAllBlank(Object ... param) {
        for (Object object : param) {
            if (object == null || !StringUtil.isNotBlank((CharSequence)object.toString())) continue;
            return false;
        }
        return true;
    }

    public static String filterSearchKey(String str, String ... filterKey) {
        str = StringUtil.filterSpace(str);
        if (filterKey != null && filterKey.length > 0 && str != null) {
            for (String string : filterKey) {
                if (!string.equals(str)) continue;
                return null;
            }
        }
        return str;
    }

    public static String filterSearchKeyAndReplace(String str, String ... filterKey) {
        str = StringUtil.filterSpace(str);
        if (!ArrayUtil.isEmpty((Object[])filterKey)) {
            for (String string : filterKey) {
                str = str.replace(string, "");
            }
        }
        return StringUtil.isBlankWithDefault(str, null);
    }

    public static String filterSpace(String str) {
        str = StringUtils.isBlank((CharSequence)str) ? null : str.trim();
        for (String key : keys) {
            if (!key.equals(str)) continue;
            return null;
        }
        return str;
    }

    public static String filterAllSpace(String str) {
        return StringUtil.filterSpace(str) == null ? null : str.replace(" ", "");
    }

    public static String likeSearch(String key, int type, String ... filterKey) {
        if ((key = StringUtil.filterSearchKey(key, filterKey)) != null) {
            return type == -1 ? "%" + key : (type == 1 ? key + "%" : "%" + key + "%");
        }
        return null;
    }

    public static String getUUIDForLength(int length) {
        if (length < 1 || length > 32) {
            length = 32;
        }
        return UUID.randomUUID().toString().replace("-", "").toUpperCase().substring(0, length);
    }

    public static boolean checkStringLength(String str, int length, boolean allowNull) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return !allowNull;
        }
        return str.length() > length;
    }

    public static String relaceUnderline(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return "";
        }
        CharSequence[] split = str.split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtil.firstCharacterToUpper((String)split[i]);
        }
        return String.join((CharSequence)"", split);
    }

    public static String relaceUnderline(String[] str) {
        for (int i = 0; i < str.length; ++i) {
            str[i] = StringUtil.firstCharacterToUpper(str[i]);
        }
        return String.join((CharSequence)"", str);
    }

    public static String firstCharacterToUpper(String srcStr) {
        return srcStr.substring(0, 1).toUpperCase() + srcStr.substring(1);
    }

    public static String removeFormat(String str) {
        return (str = StringUtil.filterAllSpace(str)) == null ? null : str.replace("\r", "").replace("\n", "").replace("\t", "");
    }

    public static boolean isContainChinese(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return false;
        }
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isChinese(String str, String ... keywords) {
        if (StringUtil.isBlank((CharSequence)(str = StringUtil.filterSearchKeyAndReplace(str, keywords)))) {
            return false;
        }
        String reg = "[\\u4e00-\\u9fa5]+";
        return str.matches(reg);
    }
}

