/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools;

import cn.minsin.core.annotation.NotNull;
import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.tools.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class ModelUtil {
    private static final String ERROR_MESSAGE_TEMPLATE = " '%s' Can't be empty,model field means '%s'";

    public static <T> SortedMap<String, String> toTreeMap(T model) throws MutilsErrorException {
        boolean flag = false;
        TreeMap<String, String> tree = new TreeMap<String, String>();
        for (Field field : ModelUtil.getAllFields(model)) {
            if (ModelUtil.verificationField(field)) continue;
            NotNull annotation = field.getAnnotation(NotNull.class);
            try {
                String key = annotation.key();
                if (StringUtil.isBlank((CharSequence)key)) {
                    key = field.getName();
                }
                field.setAccessible(true);
                Object object = field.get(model);
                if (annotation != null && annotation.notNull() && StringUtil.isBlank(object)) {
                    String description = annotation.value();
                    throw new MutilsException(String.format(ERROR_MESSAGE_TEMPLATE, key, description));
                }
                if (StringUtil.isBlank(object)) continue;
                tree.put(key, object.toString());
            }
            catch (Exception e) {
                flag = true;
                e.printStackTrace();
            }
        }
        if (flag) {
            throw new MutilsErrorException("Some fields is null.Program termination");
        }
        return tree;
    }

    public static <T> Set<Field> getAllFields(T model) {
        HashSet<Field> hashset = new HashSet<Field>();
        for (Class<?> clazz = model.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            hashset.addAll(Arrays.asList(fields));
        }
        return hashset;
    }

    public static <T> void verificationField(T model) {
        for (Field field : ModelUtil.getAllFields(model)) {
            NotNull annotation;
            if (ModelUtil.verificationField(field) || (annotation = field.getAnnotation(NotNull.class)) == null || !annotation.notNull()) continue;
            try {
                String key = field.getName();
                field.setAccessible(true);
                Object object = field.get(model);
                if (!StringUtil.isBlank(object)) continue;
                String description = annotation.value();
                throw new MutilsException(String.format(ERROR_MESSAGE_TEMPLATE, key, description));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean verificationField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) || !Modifier.isPrivate(modifiers) || Modifier.isFinal(modifiers);
    }
}

