/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.rule.AbstractModelRule;
import cn.minsin.core.tools.IOUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class FileUtil {
    public static void checkPath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void copy(File f, File nf, boolean flag) throws MutilsErrorException {
        try {
            if (f.exists()) {
                if (f.isDirectory()) {
                    if (flag && !(nf = new File(nf + "/" + f.getName())).exists()) {
                        nf.mkdirs();
                    }
                    flag = true;
                    File[] l = f.listFiles();
                    if (null != l) {
                        for (File ll : l) {
                            FileUtil.copy(ll, nf, flag);
                        }
                    }
                } else {
                    int i;
                    FileInputStream fis = new FileInputStream(f);
                    FileOutputStream fos = new FileOutputStream(nf + "/" + f.getName());
                    byte[] b = new byte[1024];
                    while ((i = fis.read(b)) != -1) {
                        fos.write(b, 0, i);
                    }
                    IOUtil.close(fos, fis);
                }
            }
        }
        catch (Exception e) {
            throw new MutilsErrorException(e, "\u6587\u4ef6\u590d\u5236\u5931\u8d25");
        }
    }

    public static boolean deleteFile(File dirFile) {
        if (!dirFile.exists()) {
            return false;
        }
        if (dirFile.isFile()) {
            return dirFile.delete();
        }
        for (File file : dirFile.listFiles()) {
            FileUtil.deleteFile(file);
        }
        return dirFile.delete();
    }

    public static boolean deleteFile(String path) {
        return FileUtil.deleteFile(new File(path));
    }

    public static FileModel readHeightAndWidth(InputStream in) throws MutilsErrorException {
        try {
            byte[] copyInputStream = IOUtil.copyInputStream(in);
            FileModel fileModel = new FileUtil().new FileModel();
            fileModel.setInputStream(new ByteArrayInputStream(copyInputStream));
            BufferedImage bi = ImageIO.read(new ByteArrayInputStream(copyInputStream));
            if (bi != null) {
                fileModel.setHeight(bi.getHeight());
                fileModel.setWidth(bi.getWidth());
                fileModel.setImage(true);
            }
            return fileModel;
        }
        catch (Exception e) {
            throw new MutilsErrorException(e, "Maybe,the inputstream is not an image or null.");
        }
    }

    public class FileModel
    extends AbstractModelRule {
        private static final long serialVersionUID = 719250036645822007L;
        private int width;
        private int height;
        private InputStream inputStream;
        private boolean isImage = false;

        public boolean isImage() {
            return this.isImage;
        }

        public void setImage(boolean isImage) {
            this.isImage = isImage;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }
}

