/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.aop.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.StaticMethodMatcher;

public class MutilsPointCut
implements Pointcut {
    private final String[] packages;
    private final Class<? extends Annotation>[] annotations;

    public MutilsPointCut(String[] packages, Class<? extends Annotation>[] annotations) {
        this.packages = packages;
        this.annotations = annotations;
    }

    public ClassFilter getClassFilter() {
        return new ClassFilter(){

            public boolean matches(Class<?> clazz) {
                if (MutilsPointCut.this.packages == null || MutilsPointCut.this.packages.length == 0) {
                    return true;
                }
                String name = clazz.getPackage().getName();
                for (String str : MutilsPointCut.this.packages) {
                    str = str.replace(".*", "");
                    if (!name.contains(name)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public MethodMatcher getMethodMatcher() {
        return new StaticMethodMatcher(){

            public boolean matches(Method method, Class<?> targetClass) {
                return this.check(method);
            }

            private boolean check(Method method) {
                for (Class anno : MutilsPointCut.this.annotations) {
                    Object annotation = method.getAnnotation(anno);
                    if (annotation == null) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

