package cn.minsin.aop.core;

import java.lang.reflect.Method;

import org.springframework.aop.AfterReturningAdvice;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

import cn.minsin.aop.annotation.LoggerRecord;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class DefaultInvoke extends AbstractMutilsInvoke implements AfterReturningAdvice {
	public DefaultInvoke(BeanDefinitionRegistry defaultListableBeanFactory) {
		super(defaultListableBeanFactory);
	}

	@Override
	public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
		LoggerRecord annotation = method.getAnnotation(LoggerRecord.class);
		if (annotation == null) {
			log.info("本次访问的方法是:{} 参数为:{}");
		} else {
			StringBuffer sb = new StringBuffer("");
			if (args != null) {
				for (Object object : args) {
					sb.append(object == null ? "" : object.toString() + ",");
				}
			}
			boolean flag = annotation.isDo();
			if (flag) {
				log.info("本次访问的方法是:{} 参数为:{} 日志结果为:{}", method.getName(), sb.toString(),
						annotation.value());
			}
		}
	}
}
