/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.aliyun.sms.function;

import cn.minsin.aliyun.sms.config.MutilsAliyunSmsProperties;
import cn.minsin.aliyun.sms.model.AliyunQueryModel;
import cn.minsin.aliyun.sms.model.AliyunSendSmsModel;
import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.rule.AbstractFunctionRule;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendBatchSmsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliyunSmsFunctions
extends AbstractFunctionRule {
    @Autowired
    private MutilsAliyunSmsProperties properties;
    private static IAcsClient client;

    @PostConstruct
    public void init() {
        if (this.properties != null) {
            client = this.initClient();
        }
    }

    public SendSmsResponse sendSingleSms(AliyunSendSmsModel model) throws ServerException, ClientException, MutilsErrorException {
        return (SendSmsResponse)client.getAcsResponse((AcsRequest)model.toSendSmsRequest());
    }

    public SendBatchSmsResponse sendBatchSms(AliyunSendSmsModel model) throws ServerException, ClientException, MutilsErrorException {
        return (SendBatchSmsResponse)client.getAcsResponse((AcsRequest)model.toSendBatchSmsRequest());
    }

    public QuerySendDetailsResponse querySendDetails(AliyunQueryModel model) throws ServerException, ClientException {
        return (QuerySendDetailsResponse)client.getAcsResponse((AcsRequest)model.toQuerySendDetailsRequest());
    }

    protected IAcsClient initClient() {
        System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(this.properties.getConnectTimeout()));
        System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(this.properties.getReadTimeout()));
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.properties.getAccessKeyId(), (String)this.properties.getAccessKeySecret());
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)this.properties.getProduct(), (String)this.properties.getDomain());
        return new DefaultAcsClient((IClientProfile)profile);
    }
}

