/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.aliyun.sms;

import cn.minsin.aliyun.sms.config.MutilsAliyunSmsProperties;
import cn.minsin.aliyun.sms.model.AliyunQueryModel;
import cn.minsin.aliyun.sms.model.AliyunSendSmsModel;
import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.AbstractConfig;
import cn.minsin.core.rule.AbstractFunctionRule;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendBatchSmsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;

public class AliyunSmsFunctions
extends AbstractFunctionRule {
    protected static final MutilsAliyunSmsProperties properties = (MutilsAliyunSmsProperties)AbstractConfig.loadConfig(MutilsAliyunSmsProperties.class);
    private static IAcsClient client;

    public static SendSmsResponse sendSingleSms(AliyunSendSmsModel model) throws ServerException, ClientException, MutilsErrorException {
        return (SendSmsResponse)client.getAcsResponse((AcsRequest)model.toSendSmsRequest());
    }

    public static SendBatchSmsResponse sendBatchSms(AliyunSendSmsModel model) throws ServerException, ClientException, MutilsErrorException {
        return (SendBatchSmsResponse)client.getAcsResponse((AcsRequest)model.toSendBatchSmsRequest());
    }

    public static QuerySendDetailsResponse querySendDetails(AliyunQueryModel model) throws ServerException, ClientException {
        return (QuerySendDetailsResponse)client.getAcsResponse((AcsRequest)model.toQuerySendDetailsRequest());
    }

    protected static IAcsClient initClient() {
        System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(properties.getConnectTimeout()));
        System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(properties.getReadTimeout()));
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)properties.getAccessKeyId(), (String)properties.getAccessKeySecret());
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)properties.getProduct(), (String)properties.getDomain());
        return new DefaultAcsClient((IClientProfile)profile);
    }

    static {
        AliyunSmsFunctions.checkProperties((AbstractConfig)properties, MutilsAliyunSmsProperties.class);
        if (properties != null) {
            client = AliyunSmsFunctions.initClient();
        }
    }
}

