/*
 * Decompiled with CFR 0.152.
 */
package cn.mutils.aliyun.oss;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.childconfig.AliyunOssMultiConfig;
import cn.mutils.aliyun.oss.AliyunOssBaseFunctions;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;

public class AliyunOssUploadFunctions
extends AliyunOssBaseFunctions {
    protected AliyunOssUploadFunctions(AliyunOssMultiConfig config) {
        super(config);
    }

    public String uplodeToOss(MultipartFile file, boolean isCover) throws MutilsErrorException, IOException {
        return this.uploadToOss(file.getOriginalFilename(), file.getInputStream(), isCover);
    }

    public String uplodeToOss(File file, boolean isCover) throws MutilsErrorException, OSSException, ClientException, FileNotFoundException {
        if (file == null || !file.exists()) {
            throw new MutilsErrorException("The file is not exists.");
        }
        return this.uploadToOss(file.getName(), new FileInputStream(file), isCover);
    }

    public String uplodeToOss(InputStream file, String fileName, boolean isCover) {
        return this.uploadToOss(fileName, file, isCover);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uploadToOss(String fileName, InputStream in, boolean isCover) throws OSSException, ClientException {
        OSS initClient = this.initClient();
        try {
            String filename = this.childConfig.createOssSaveDir(fileName);
            if (!isCover) {
                filename = this.createNewName(filename);
            }
            initClient.putObject(this.childConfig.getBucketName(), filename, in);
            String string = filename;
            return string;
        }
        finally {
            initClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createNewName(String name) throws OSSException, ClientException {
        OSS initClient = this.initClient();
        try {
            boolean exists;
            String gName = name;
            int count = 0;
            while (exists = initClient.doesObjectExist(this.childConfig.getBucketName(), gName)) {
                int index = name.lastIndexOf(".");
                String extension = "";
                if (index > 0) {
                    extension = name.substring(index, name.length());
                }
                gName = name.replace(extension, "") + "-copy(" + ++count + ")" + extension;
            }
            String string = gName;
            return string;
        }
        finally {
            initClient.shutdown();
        }
    }

    public static AliyunOssUploadFunctions init(String prefix) throws MutilsErrorException {
        return new AliyunOssUploadFunctions(AliyunOssUploadFunctions.loadConfig(prefix));
    }
}

