/*
 * Decompiled with CFR 0.152.
 */
package cn.mutils.aliyun.oss;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.childconfig.AliyunOssMultiConfig;
import cn.mutils.aliyun.oss.AliyunOssBaseFunctions;
import cn.mutils.aliyun.oss.model.AliyunOssFileFilterModel;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ObjectListing;
import java.net.URL;
import java.util.Date;
import java.util.List;

public class AliyunOssManageFunctions
extends AliyunOssBaseFunctions {
    protected AliyunOssManageFunctions(AliyunOssMultiConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExists(String fileName) throws OSSException, ClientException {
        OSS initClient = this.initClient();
        try {
            boolean bl = initClient.doesObjectExist(this.childConfig.getBucketName(), fileName);
            return bl;
        }
        finally {
            initClient.shutdown();
        }
    }

    public void deleteSingle(String fileName) throws OSSException, ClientException {
        OSS initClient = this.initClient();
        try {
            initClient.deleteObject(this.childConfig.getBucketName(), fileName);
        }
        finally {
            initClient.shutdown();
        }
    }

    public void deleteMany(List<String> keys) throws OSSException, ClientException {
        OSS initClient = this.initClient();
        try {
            initClient.deleteObjects(new DeleteObjectsRequest(this.childConfig.getBucketName()).withKeys(keys).withQuiet(true));
        }
        finally {
            initClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectListing list(AliyunOssFileFilterModel model) {
        OSS initClient = this.initClient();
        try {
            ListObjectsRequest listObjectsRequest = model.toListObjectsRequest();
            listObjectsRequest.setBucketName(this.childConfig.getBucketName());
            ObjectListing objectListing = initClient.listObjects(listObjectsRequest);
            return objectListing;
        }
        finally {
            initClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUrl(String fileName, long timeout, HttpMethod method) {
        if (timeout < 600000L) {
            timeout = 604800000L;
        }
        if (method == null) {
            method = HttpMethod.GET;
        }
        OSS initClient = this.initClient();
        try {
            Date expiration = new Date(System.currentTimeMillis() + timeout);
            URL url = initClient.generatePresignedUrl(this.childConfig.getBucketName(), fileName, expiration, method);
            String string = url == null ? null : url.toString();
            return string;
        }
        finally {
            initClient.shutdown();
        }
    }

    public static AliyunOssManageFunctions init(String prefix) throws MutilsErrorException {
        return new AliyunOssManageFunctions(AliyunOssManageFunctions.loadConfig(prefix));
    }
}

