/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.alipay.function;

import cn.minsin.alipay.config.MutilsAlipayProperties;
import cn.minsin.alipay.model.NotifyModel;
import cn.minsin.alipay.model.PayModel;
import cn.minsin.alipay.model.RefundModel;
import cn.minsin.alipay.model.TransferModel;
import cn.minsin.core.rule.AbstractFunctionRule;
import cn.minsin.core.tools.MapUtil;
import cn.minsin.core.tools.ModelUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlipayFunctions
extends AbstractFunctionRule {
    @Autowired
    protected MutilsAlipayProperties properties;

    public AlipayTradePrecreateResponse createWebAlipayParams(PayModel payModel) throws AlipayApiException {
        ModelUtil.verificationField((Object)((Object)payModel));
        AlipayTradePrecreateRequest alipayRequest = new AlipayTradePrecreateRequest();
        alipayRequest.setBizContent(payModel.toString());
        alipayRequest.setNotifyUrl(this.properties.getNotifyUrl());
        return (AlipayTradePrecreateResponse)this.initAlipayClient().execute((AlipayRequest)alipayRequest);
    }

    public AlipayTradeAppPayResponse createAlipayParams(PayModel payModel) throws AlipayApiException {
        ModelUtil.verificationField((Object)((Object)payModel));
        AlipayTradeAppPayRequest alipayRequest = new AlipayTradeAppPayRequest();
        alipayRequest.setBizContent(payModel.toString());
        alipayRequest.setNotifyUrl(this.properties.getNotifyUrl());
        return (AlipayTradeAppPayResponse)this.initAlipayClient().sdkExecute((AlipayRequest)alipayRequest);
    }

    public AlipayFundTransToaccountTransferResponse transfer(TransferModel model) throws AlipayApiException {
        ModelUtil.verificationField((Object)((Object)model));
        AlipayFundTransToaccountTransferRequest alipayRequest = new AlipayFundTransToaccountTransferRequest();
        alipayRequest.setBizContent(model.toString());
        return (AlipayFundTransToaccountTransferResponse)this.initAlipayClient().execute((AlipayRequest)alipayRequest);
    }

    public AlipayTradeRefundResponse refund(RefundModel model) throws AlipayApiException {
        ModelUtil.verificationField((Object)((Object)model));
        AlipayTradeRefundRequest alipayRequest = new AlipayTradeRefundRequest();
        alipayRequest.setBizContent(model.toString());
        return (AlipayTradeRefundResponse)this.initAlipayClient().execute((AlipayRequest)alipayRequest);
    }

    public NotifyModel parseNotify(HttpServletRequest req, boolean checkSign) throws UnsupportedEncodingException {
        req.setCharacterEncoding("utf-8");
        HashMap<String, String> retMap = new HashMap<String, String>();
        Map requestParams = req.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            retMap.put(name, valueStr);
        }
        if (checkSign && !this.checkSign(retMap)) {
            return null;
        }
        return (NotifyModel)((Object)MapUtil.mapToObject(retMap, NotifyModel.class));
    }

    public boolean checkSign(Map<String, String> params) {
        try {
            return AlipaySignature.rsaCheckV1(params, (String)this.properties.getPublicKey(), (String)this.properties.getCharset(), (String)this.properties.getSignType());
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected AlipayClient initAlipayClient() {
        return new DefaultAlipayClient(this.properties.getServerUrl(), this.properties.getAppid(), this.properties.getPrivateKey(), this.properties.getFormat(), this.properties.getCharset(), this.properties.getPublicKey(), this.properties.getSignType());
    }
}

