/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.alipay;

import cn.minsin.alipay.model.NotifyModel;
import cn.minsin.alipay.model.PayModel;
import cn.minsin.alipay.model.RefundModel;
import cn.minsin.alipay.model.TransferModel;
import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.AlipayConfig;
import cn.minsin.core.init.core.InitConfig;
import cn.minsin.core.rule.FunctionRule;
import cn.minsin.core.web.VO;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AlipayFunctions
extends FunctionRule {
    private static final AlipayConfig config = (AlipayConfig)InitConfig.loadConfig(AlipayConfig.class);

    public static AlipayTradePrecreateResponse createWebAlipayParams(PayModel payModel) throws MutilsErrorException {
        try {
            AlipayTradePrecreateRequest alipayRequest = new AlipayTradePrecreateRequest();
            alipayRequest.setBizContent(payModel.toString());
            alipayRequest.setNotifyUrl(config.getNotifyUrl());
            return (AlipayTradePrecreateResponse)AlipayFunctions.initAlipayClient().execute((AlipayRequest)alipayRequest);
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "Create Alipay Web payment failure.");
        }
    }

    public static AlipayTradeAppPayResponse createAlipayParams(PayModel payModel) throws MutilsErrorException {
        try {
            AlipayTradeAppPayRequest alipayRequest = new AlipayTradeAppPayRequest();
            alipayRequest.setBizContent(payModel.toString());
            alipayRequest.setNotifyUrl(config.getNotifyUrl());
            return (AlipayTradeAppPayResponse)AlipayFunctions.initAlipayClient().sdkExecute((AlipayRequest)alipayRequest);
        }
        catch (AlipayApiException e) {
            throw new MutilsErrorException((Throwable)e, "Create Alipay mobile payment failure.");
        }
    }

    public static AlipayFundTransToaccountTransferResponse transfer(TransferModel model) throws MutilsErrorException {
        try {
            AlipayFundTransToaccountTransferRequest alipayRequest = new AlipayFundTransToaccountTransferRequest();
            alipayRequest.setBizContent(model.toString());
            return (AlipayFundTransToaccountTransferResponse)AlipayFunctions.initAlipayClient().execute((AlipayRequest)alipayRequest);
        }
        catch (AlipayApiException e) {
            throw new MutilsErrorException((Throwable)e, "Initiation of Alipay transfer failed.");
        }
    }

    public static AlipayTradeRefundResponse refund(RefundModel model) throws MutilsErrorException {
        try {
            AlipayTradeRefundRequest alipayRequest = new AlipayTradeRefundRequest();
            alipayRequest.setBizContent(model.toString());
            return (AlipayTradeRefundResponse)AlipayFunctions.initAlipayClient().execute((AlipayRequest)alipayRequest);
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "Initiating Alipay refund failed.");
        }
    }

    public static NotifyModel parseNotify(HttpServletRequest req) throws MutilsErrorException {
        try {
            req.setCharacterEncoding("utf-8");
            VO init = VO.init();
            Map requestParams = req.getParameterMap();
            for (String name : requestParams.keySet()) {
                String[] values = (String[])requestParams.get(name);
                String valueStr = "";
                for (int i = 0; i < values.length; ++i) {
                    valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
                }
                init.put(name, (Object)valueStr);
            }
            return (NotifyModel)((Object)init.toObject(NotifyModel.class));
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "Parsing alipay callback failed.");
        }
    }

    protected static AlipayClient initAlipayClient() {
        return new DefaultAlipayClient(config.getServerUrl(), config.getAppid(), config.getPrivateKey(), config.getFormat(), config.getCharset(), config.getPublicKey(), config.getSignType());
    }
}

