/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.alipay;

import cn.minsin.alipay.model.TransferModel;
import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.AlipayConfig;
import cn.minsin.core.rule.FunctionRule;
import cn.minsin.core.web.VO;
import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;

public class AlipayFunctions
extends FunctionRule {
    public static String createWebAlipayParams(String out_trade_no, BigDecimal price, String title) throws MutilsErrorException {
        try {
            price = price.setScale(2, RoundingMode.DOWN);
            AlipayTradePrecreateRequest alipayRequest = new AlipayTradePrecreateRequest();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("subject", title);
            map.put("out_trade_no", out_trade_no);
            map.put("total_amount", price);
            alipayRequest.setBizContent(JSON.toJSONString(map));
            alipayRequest.setNotifyUrl(AlipayConfig.alipayConfig.getNotifyUrl());
            map.clear();
            map.put("orderNum", out_trade_no);
            AlipayTradePrecreateResponse response = (AlipayTradePrecreateResponse)AlipayFunctions.initAlipayClient().execute((AlipayRequest)alipayRequest);
            if (response.isSuccess()) {
                return response.getQrCode();
            }
            return null;
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "\u652f\u4ed8\u5b9d\u521b\u5efa\u7f51\u9875\u652f\u4ed8\u5931\u8d25 ");
        }
    }

    public static String createAlipayParams(String out_trade_no, BigDecimal price, String title) throws MutilsErrorException {
        try {
            price = price.setScale(2, RoundingMode.DOWN);
            AlipayTradeAppPayRequest alipayRequest = new AlipayTradeAppPayRequest();
            AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
            model.setOutTradeNo(out_trade_no);
            model.setTotalAmount(price.toString());
            model.setSubject(title);
            alipayRequest.setBizModel((AlipayObject)model);
            alipayRequest.setNotifyUrl(AlipayConfig.alipayConfig.getNotifyUrl());
            AlipayTradeAppPayResponse response = (AlipayTradeAppPayResponse)AlipayFunctions.initAlipayClient().sdkExecute((AlipayRequest)alipayRequest);
            if (response.isSuccess()) {
                return response.getBody();
            }
            return null;
        }
        catch (AlipayApiException e) {
            throw new MutilsErrorException((Throwable)e, "\u652f\u4ed8\u5b9d\u521b\u5efaAPP\u652f\u4ed8\u5931\u8d25");
        }
    }

    public static VO transfer(TransferModel model) throws MutilsErrorException {
        AlipayFundTransToaccountTransferRequest alipayRequest = new AlipayFundTransToaccountTransferRequest();
        alipayRequest.setBizContent(JSON.toJSONString((Object)((Object)model)));
        AlipayFundTransToaccountTransferResponse response = null;
        try {
            response = (AlipayFundTransToaccountTransferResponse)AlipayFunctions.initAlipayClient().execute((AlipayRequest)alipayRequest);
            return VO.builder().put("code", (Object)response.getCode()).put("sub_msg", (Object)response.getSubMsg());
        }
        catch (AlipayApiException e) {
            throw new MutilsErrorException((Throwable)e, "\u652f\u4ed8\u5b9d\u8f6c\u8d26\u5931\u8d25");
        }
    }

    static AlipayClient initAlipayClient() {
        return new DefaultAlipayClient(AlipayConfig.alipayConfig.getServerUrl(), AlipayConfig.alipayConfig.getAppid(), AlipayConfig.alipayConfig.getPrivateKey(), AlipayConfig.alipayConfig.getFormat(), AlipayConfig.alipayConfig.getCharset(), AlipayConfig.alipayConfig.getPublicKey(), AlipayConfig.alipayConfig.getSignType());
    }
}

