/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.alipay;

import cn.minsin.alipay.model.NotifyModel;
import cn.minsin.alipay.model.PayModel;
import cn.minsin.alipay.model.RefundModel;
import cn.minsin.alipay.model.TransferModel;
import cn.minsin.core.init.AlipayConfig;
import cn.minsin.core.init.core.AbstractConfig;
import cn.minsin.core.rule.AbstractFunctionRule;
import cn.minsin.core.tools.MapUtil;
import cn.minsin.core.tools.ModelUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AlipayFunctions
extends AbstractFunctionRule {
    private static final AlipayConfig config = (AlipayConfig)AbstractConfig.loadConfig(AlipayConfig.class);

    public static AlipayTradePrecreateResponse createWebAlipayParams(PayModel payModel) throws AlipayApiException {
        ModelUtil.verificationField((Object)((Object)payModel));
        AlipayTradePrecreateRequest alipayRequest = new AlipayTradePrecreateRequest();
        alipayRequest.setBizContent(payModel.toString());
        alipayRequest.setNotifyUrl(config.getNotifyUrl());
        return (AlipayTradePrecreateResponse)AlipayFunctions.initAlipayClient().execute((AlipayRequest)alipayRequest);
    }

    public static AlipayTradeAppPayResponse createAlipayParams(PayModel payModel) throws AlipayApiException {
        ModelUtil.verificationField((Object)((Object)payModel));
        AlipayTradeAppPayRequest alipayRequest = new AlipayTradeAppPayRequest();
        alipayRequest.setBizContent(payModel.toString());
        alipayRequest.setNotifyUrl(config.getNotifyUrl());
        return (AlipayTradeAppPayResponse)AlipayFunctions.initAlipayClient().sdkExecute((AlipayRequest)alipayRequest);
    }

    public static AlipayFundTransToaccountTransferResponse transfer(TransferModel model) throws AlipayApiException {
        ModelUtil.verificationField((Object)((Object)model));
        AlipayFundTransToaccountTransferRequest alipayRequest = new AlipayFundTransToaccountTransferRequest();
        alipayRequest.setBizContent(model.toString());
        return (AlipayFundTransToaccountTransferResponse)AlipayFunctions.initAlipayClient().execute((AlipayRequest)alipayRequest);
    }

    public static AlipayTradeRefundResponse refund(RefundModel model) throws AlipayApiException {
        ModelUtil.verificationField((Object)((Object)model));
        AlipayTradeRefundRequest alipayRequest = new AlipayTradeRefundRequest();
        alipayRequest.setBizContent(model.toString());
        return (AlipayTradeRefundResponse)AlipayFunctions.initAlipayClient().execute((AlipayRequest)alipayRequest);
    }

    public static NotifyModel parseNotify(HttpServletRequest req, boolean checkSign) throws UnsupportedEncodingException {
        req.setCharacterEncoding("utf-8");
        HashMap<String, String> retMap = new HashMap<String, String>();
        Map requestParams = req.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            retMap.put(name, valueStr);
        }
        if (checkSign && !AlipayFunctions.checkSign(retMap)) {
            return null;
        }
        return (NotifyModel)((Object)MapUtil.mapToObject(retMap, NotifyModel.class));
    }

    public static boolean checkSign(Map<String, String> params) {
        try {
            return AlipaySignature.rsaCheckV1(params, (String)config.getPublicKey(), (String)config.getCharset(), (String)config.getSignType());
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static AlipayClient initAlipayClient() {
        return new DefaultAlipayClient(config.getServerUrl(), config.getAppid(), config.getPrivateKey(), config.getFormat(), config.getCharset(), config.getPublicKey(), config.getSignType());
    }
}

