/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.mapper.log;

import cn.miniants.framework.bean.BeanConvert;
import cn.miniants.framework.mapper.log.OplogContext;
import cn.miniants.framework.web.UserSession;
import cn.miniants.toolkit.JSONUtil;
import com.baomidou.kisso.common.IpHelper;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;

public class Oplog
implements BeanConvert {
    private Long createId;
    private String createBy;
    private Date createTime;
    private String service;
    private String module;
    private String business;
    private String method;
    private Integer type;
    private String content;
    private String params;
    private String browser;
    private String ip;
    private String uri;
    private Long duration;

    public Oplog service(String service) {
        this.service = service;
        return this;
    }

    public Oplog module(String module) {
        this.module = module;
        return this;
    }

    public Oplog business(String business) {
        this.business = business;
        return this;
    }

    public Oplog content(String content) {
        this.content = content;
        return this;
    }

    public Oplog audit(UserSession userSession) {
        if (null != userSession) {
            this.createId = userSession.getId();
            this.createBy = userSession.getUsername();
        }
        return this;
    }

    public Oplog status(boolean success) {
        this.type = success ? 0 : 1;
        return this;
    }

    public Oplog failed() {
        return this.status(false);
    }

    public Oplog exception(String exception) {
        this.content = exception;
        this.type = 2;
        return this;
    }

    public Oplog around(Signature signature, HttpServletRequest request, Object[] args) {
        MethodSignature ms;
        Method method;
        Class<Void> methodReturnType;
        if (null == this.createId) {
            this.audit(UserSession.getCurSession());
        }
        if (null != args && args.length > 0) {
            this.params = JSONUtil.toJSONString((Object)args);
        }
        if (!(methodReturnType = (method = (ms = (MethodSignature)signature).getMethod()).getReturnType()).isAssignableFrom(Void.TYPE) && null != args && args.length > 0) {
            this.params = JSONUtil.toJSONString((Object)args);
        }
        this.method = ms.getDeclaringTypeName() + "." + ms.getName();
        this.browser = request.getHeader("User-Agent");
        this.uri = request.getRequestURI();
        this.ip = IpHelper.getIpAddr((HttpServletRequest)request);
        return this;
    }

    public Oplog build(long duration) {
        this.createTime = new Date();
        this.duration = duration;
        OplogContext.OPLOG_HOLDER.set(this);
        return this;
    }

    public Long getCreateId() {
        return this.createId;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getService() {
        return this.service;
    }

    public String getModule() {
        return this.module;
    }

    public String getBusiness() {
        return this.business;
    }

    public String getMethod() {
        return this.method;
    }

    public Integer getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getParams() {
        return this.params;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUri() {
        return this.uri;
    }

    public Long getDuration() {
        return this.duration;
    }
}

