/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.URLDecoder;
import cn.miniants.framework.api.ApiController;
import cn.miniants.framework.api.PageParam;
import cn.miniants.framework.bean.SuperEntity;
import cn.miniants.framework.pagesqlhandle.SqlDbHandelUtil;
import cn.miniants.framework.service.BaseServiceImpl;
import cn.miniants.framework.validation.Create;
import cn.miniants.framework.validation.Update;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public class BaseController<BS extends BaseServiceImpl<?, M>, M extends SuperEntity>
extends ApiController {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    protected BS baseService;

    @PostMapping
    public boolean add(@Validated(value={Create.class}) @RequestBody M entity) {
        return this.baseService.save(entity);
    }

    @GetMapping(value={"/{id}"})
    public M get(@PathVariable Long id) {
        return (M)((SuperEntity)this.baseService.getById((Serializable)id));
    }

    @PutMapping
    public boolean update(@Validated(value={Update.class}) @RequestBody M entity) {
        Assert.notNull((Object)((SuperEntity)entity).getId(), (String)"\u66f4\u65b0 Id \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.baseService.updateById(entity);
    }

    @DeleteMapping(value={"/{id}"})
    public boolean delete(@PathVariable Long id) {
        return this.baseService.removeById((Serializable)id);
    }

    @GetMapping(value={"/page"})
    public Page<?> page(PageParam<?> myPageParam) {
        String filterStr = URLDecoder.decode((String)myPageParam.getFilter(), (Charset)Charset.defaultCharset());
        SqlDbHandelUtil sqlDbHandelUtil = new SqlDbHandelUtil(filterStr, myPageParam.getOrder());
        return (Page)this.baseService.page(myPageParam.page(), (Wrapper)sqlDbHandelUtil.getWrapper());
    }
}

