/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.api;

import cn.miniants.framework.api.ApiErrorCode;
import cn.miniants.framework.api.IErrorCode;
import cn.miniants.framework.exception.ApiException;
import java.io.Serializable;
import java.util.Optional;

public class ApiResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long code;
    private T data;
    private String message;
    private String errorDetails;

    public ApiResult() {
    }

    public ApiResult(IErrorCode errorCode) {
        errorCode = Optional.ofNullable(errorCode).orElse(ApiErrorCode.FAILED);
        this.code = errorCode.getCode();
        this.message = errorCode.getMsg();
    }

    public static <T> ApiResult<T> ok(T data) {
        ApiErrorCode aec = ApiErrorCode.SUCCESS;
        if (data instanceof Boolean && Boolean.FALSE.equals(data)) {
            aec = ApiErrorCode.FAILED;
        }
        return ApiResult.result(data, aec.getCode(), aec.getMsg());
    }

    public static <T> ApiResult<T> failed(String msg) {
        return ApiResult.result(null, ApiErrorCode.FAILED.getCode(), msg);
    }

    public static <T> ApiResult<T> failed(String msg, T data) {
        return ApiResult.result(data, ApiErrorCode.FAILED.getCode(), msg);
    }

    public static <T> ApiResult<T> failed(IErrorCode errorCode) {
        return ApiResult.result(null, errorCode);
    }

    public static <T> ApiResult<T> result(T data, IErrorCode errorCode) {
        return ApiResult.result(data, errorCode.getCode(), errorCode.getMsg());
    }

    public static <T> ApiResult<T> result(T data, long code, String message) {
        ApiResult<T> apiResult = new ApiResult<T>();
        apiResult.setCode(code);
        apiResult.setData(data);
        apiResult.setMessage(message);
        return apiResult;
    }

    public boolean ok() {
        return ApiErrorCode.SUCCESS.getCode() == this.code;
    }

    public T serviceData() {
        if (!this.ok()) {
            throw new ApiException(this.message);
        }
        return this.data;
    }

    public long getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public ApiResult<T> setCode(long code) {
        this.code = code;
        return this;
    }

    public ApiResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    public ApiResult<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public ApiResult<T> setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }
}

