/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.advice;

import cn.hutool.core.util.ObjectUtil;
import cn.miniants.framework.api.ApiResult;
import cn.miniants.framework.exception.MiniFeignException;
import cn.miniants.toolkit.JSONUtil;
import feign.Response;
import feign.codec.Decoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringDecoder;

public class MiniFeignDecoder
implements Decoder {
    private static final Logger log = LoggerFactory.getLogger(MiniFeignDecoder.class);
    private final Decoder delegate;

    public MiniFeignDecoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.delegate = new SpringDecoder(messageConverters);
    }

    public Object decode(Response response, final Type type) throws IOException {
        Map headers = response.headers();
        if (ObjectUtil.isNotNull(response.headers().get("Mini-Api")) && ((Collection)headers.get("Mini-Api")).stream().anyMatch(value -> value.contains("true")) && ((Collection)headers.get("Content-Type")).stream().anyMatch(value -> value.contains("text/plain") || value.contains("application/json"))) {
            Object var8_11;
            ParameterizedType wrappedType = new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{type};
                }

                @Override
                public Type getRawType() {
                    return ApiResult.class;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            };
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.body().asInputStream()));
            try {
                String responseBody = reader.lines().collect(Collectors.joining("\n"));
                ApiResult apiResponse = (ApiResult)JSONUtil.readValue((String)responseBody, (Type)wrappedType);
                var8_11 = null == apiResponse ? null : apiResponse.getData();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("\u89e3\u7801FeignClient\u62a5\u6587\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u53ca\u5176\u4ed6\u914d\u7f6e.", (Throwable)e);
                    throw new MiniFeignException(503, "\u89e3\u7801FeignClient\u62a5\u6587\u9519\u8bef", e.getMessage());
                }
            }
            reader.close();
            return var8_11;
        }
        return this.delegate.decode(response, type);
    }
}

