/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.advice;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.miniants.framework.advice.MiniControllerResult;
import cn.miniants.framework.api.ApiResult;
import cn.miniants.framework.api.IErrorCode;
import cn.miniants.framework.exception.ApiException;
import cn.miniants.framework.exception.MiniFeignException;
import cn.miniants.framework.spring.SpringHelper;
import cn.miniants.toolkit.JSONUtil;
import io.jsonwebtoken.JwtException;
import java.io.EOFException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.apache.catalina.connector.ClientAbortException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.springframework.web.util.NestedServletException;

@RestControllerAdvice
public class MiniControllerResultAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(MiniControllerResultAdvice.class);
    @Value(value="${spring.validation.message.enable:true}")
    private Boolean enableValidationMessage;
    @Value(value="${miniants.api.returnErrorDetails:true}")
    private Boolean returnErrorDetails;

    public boolean supports(@NotNull MethodParameter returnType, @NotNull Class converterType) {
        Method m = returnType.getMethod();
        return m != null && m.getReturnType() != Void.TYPE;
    }

    public Object beforeBodyWrite(Object body, @NotNull MethodParameter returnType, @NotNull MediaType selectedContentType, @NotNull Class selectedConverterType, @NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response) {
        MiniControllerResult myAnnotation;
        response.getHeaders().add("Mini-Api", "true");
        if (body instanceof ApiResult) {
            return body;
        }
        Method method = returnType.getMethod();
        if (method != null && (myAnnotation = method.getAnnotation(MiniControllerResult.class)) != null && myAnnotation.skipWrapper()) {
            return body;
        }
        ApiResult<Object> apiResult = ApiResult.ok(body);
        if (returnType.getParameterType().isAssignableFrom(String.class)) {
            return JSONUtil.toJSONString(apiResult);
        }
        return apiResult;
    }

    private String convertFiledErrors(List<FieldError> fieldErrors) {
        return Optional.ofNullable(fieldErrors).filter(fieldErrorsInner -> this.enableValidationMessage).map(fieldErrorsInner -> fieldErrorsInner.stream().flatMap(fieldError -> Stream.of(fieldError.getField() + " " + fieldError.getDefaultMessage())).collect(Collectors.joining(", "))).orElse(null);
    }

    private String convertConstraintViolationsToMessage(ConstraintViolationException constraintViolationException) {
        return Optional.ofNullable(constraintViolationException.getConstraintViolations()).filter(constraintViolations -> this.enableValidationMessage).map(constraintViolations -> constraintViolations.stream().flatMap(constraintViolation -> {
            String path = constraintViolation.getPropertyPath().toString();
            String errorMessage = path.substring(path.lastIndexOf(".") + 1) + " " + constraintViolation.getMessage();
            return Stream.of(errorMessage);
        }).collect(Collectors.joining(", "))).orElse(null);
    }

    private static boolean isClientAbort(Throwable e) {
        Throwable root = ExceptionUtil.getRootCause((Throwable)e);
        Throwable t = root != null ? root : e;
        String msg = (t.getMessage() == null ? "" : t.getMessage()).toLowerCase();
        return t instanceof ClientAbortException || t instanceof EOFException || msg.contains("broken pipe") || msg.contains("connection reset by peer") || msg.contains("connection reset");
    }

    private static Throwable unwrapNested(Throwable e) {
        if (e instanceof NestedServletException && e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }

    @ExceptionHandler(value={Exception.class})
    public ApiResult<Object> handleBadRequest(Exception ex, HttpServletResponse resp, HttpServletRequest req) {
        Throwable e = MiniControllerResultAdvice.unwrapNested(ex);
        if (resp.isCommitted() || MiniControllerResultAdvice.isClientAbort(e)) {
            if (!resp.isCommitted()) {
                resp.setStatus(204);
            }
            log.debug("[CLIENT-ABORT] {} {} -> {}", new Object[]{req.getMethod(), req.getRequestURI(), e.getMessage()});
            return null;
        }
        if (e instanceof ApiException) {
            IErrorCode errorCode = ((ApiException)e).getErrorCode();
            return null != errorCode ? ApiResult.failed(errorCode) : ApiResult.failed(e.getMessage());
        }
        if (e instanceof BindException) {
            ApiResult<Object> res = ApiResult.failed(this.convertFiledErrors(((BindException)e).getBindingResult().getFieldErrors()));
            if (SpringHelper.isValidationControllerMethod()) {
                resp.setStatus(200);
                res.setCode(201L);
            }
            return res;
        }
        if (e instanceof JwtException) {
            resp.setStatus(401);
            return ApiResult.result(e, 4001L, "token\u8fc7\u671f\u6216\u65e0\u6548");
        }
        if (e instanceof MiniFeignException) {
            resp.setStatus(((MiniFeignException)e).getErrorCode());
            ApiResult<Object> res = ApiResult.failed(e.getMessage());
            res.setErrorDetails(((MiniFeignException)e).getFeignTraceMessage());
            return res;
        }
        if (e instanceof ConstraintViolationException) {
            ApiResult<Object> res = ApiResult.failed(this.convertConstraintViolationsToMessage((ConstraintViolationException)e));
            return res;
        }
        resp.setStatus(503);
        ApiResult<Object> res = ApiResult.failed("Service Error:%s".formatted(e.getMessage()));
        if (this.returnErrorDetails.booleanValue()) {
            res.setErrorDetails(ExceptionUtil.stacktraceToString((Throwable)e));
        }
        log.error("Service Error: {}", (Object)ExceptionUtil.stacktraceToString((Throwable)e));
        return res;
    }
}

