/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.web;

import cn.miniants.framework.interceptor.ControllerStatusHandlerInterceptor;
import cn.miniants.framework.web.IExcludePaths;
import com.baomidou.kisso.SSOAuthorization;
import com.baomidou.kisso.web.handler.SSOHandlerInterceptor;
import com.baomidou.kisso.web.interceptor.SSOPermissionInterceptor;
import com.baomidou.kisso.web.interceptor.SSOSpringInterceptor;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class ServiceWebMvcConfigurer
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ServiceWebMvcConfigurer.class);
    private SSOAuthorization ssoAuthorization;
    private IExcludePaths excludePaths;

    public void addInterceptors(InterceptorRegistry registry) {
        SSOSpringInterceptor ssoInterceptor = new SSOSpringInterceptor();
        ssoInterceptor.setHandlerInterceptor(new SSOHandlerInterceptor(){
            private static final String CONTENT_TYPE_ERR = "application/json; charset=utf-8";

            public boolean preTokenIsNullAjax(HttpServletRequest request, HttpServletResponse response) {
                return false;
            }

            public boolean preTokenIsNull(HttpServletRequest request, HttpServletResponse response) {
                log.info("\u6ca1\u6709\u767b\u5f55\u9700\u8981\u767b\u5f55\u540e\u624d\u80fd\u8bbf\u95ee\uff01 \u8bbf\u95ee\u8def\u5f84={}", (Object)request.getRequestURI());
                response.setCharacterEncoding("UTF-8");
                response.setContentType(CONTENT_TYPE_ERR);
                response.setStatus(401);
                response.getWriter().write("\u6ca1\u6709\u767b\u5f55\uff0c\u7981\u6b62\u8bbf\u95ee");
                return false;
            }
        });
        InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)ssoInterceptor);
        registration.addPathPatterns(new String[]{"/**"});
        SSOPermissionInterceptor permissionInterceptor = new SSOPermissionInterceptor();
        permissionInterceptor.setAuthorization(this.ssoAuthorization);
        registry.addInterceptor((HandlerInterceptor)new ControllerStatusHandlerInterceptor());
        permissionInterceptor.setNothingAnnotationPass(true);
        InterceptorRegistration registrationPermission = registry.addInterceptor((HandlerInterceptor)permissionInterceptor);
        registrationPermission.addPathPatterns(new String[]{"/**"});
        ArrayList<String> eps = new ArrayList<String>();
        eps.add("/v3/api-docs/**");
        if (null != this.excludePaths) {
            eps.addAll(this.excludePaths.getPaths());
        }
        registration.excludePathPatterns(eps);
        registrationPermission.excludePathPatterns(eps);
    }

    public ServiceWebMvcConfigurer(SSOAuthorization ssoAuthorization, IExcludePaths excludePaths) {
        this.ssoAuthorization = ssoAuthorization;
        this.excludePaths = excludePaths;
    }
}

