/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.pagesqlhandle.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.miniants.framework.pagesqlhandle.filter.Filter;
import cn.miniants.framework.pagesqlhandle.filter.FilterGroup;
import cn.miniants.framework.pagesqlhandle.filter.FilterOperational;
import cn.miniants.toolkit.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class FilterHandlerUtil {
    private static final LinkedHashMap<String, FilterGroup> GROUP_ENUM_MAP = EnumUtil.getEnumMap(FilterGroup.class);
    private static final LinkedHashMap<String, FilterOperational> OP_ENUM_MAP = EnumUtil.getEnumMap(FilterOperational.class);
    private String filterStr;
    private Filter filter;

    public FilterHandlerUtil(String filterStr) {
        if (StrUtil.isNotEmpty((CharSequence)filterStr)) {
            this.filterStr = filterStr;
            Map stringObjectMap = JSONUtil.readMap((String)filterStr);
            Filter temp_filter = this.handleFilterJsonStr(FilterGroup.$and, stringObjectMap);
            this.filter = this.cleanFilter(temp_filter);
        }
    }

    public QueryWrapper getFilterWrapper() {
        QueryWrapper condition = new QueryWrapper();
        if (ObjectUtil.isNotNull((Object)this.filter) && (CollUtil.isNotEmpty(this.filter.getFilterBeanList()) || CollUtil.isNotEmpty(this.filter.getChildFilterList()))) {
            this.groupHandle(condition, this.filter);
        }
        return condition;
    }

    private Filter cleanFilter(Filter filter) {
        if (ObjectUtil.isNotNull((Object)filter) && CollUtil.isEmpty(filter.getFilterBeanList())) {
            if (CollUtil.isEmpty(filter.getChildFilterList())) {
                filter = null;
            } else {
                ArrayList<Filter> tempChildFilter = new ArrayList<Filter>(filter.getChildFilterList().size());
                filter.getChildFilterList().forEach(childFilter -> tempChildFilter.add(this.cleanFilter((Filter)childFilter)));
                tempChildFilter.removeIf(Objects::isNull);
                if (CollUtil.isEmpty(tempChildFilter)) {
                    filter = null;
                } else if (tempChildFilter.size() == 1) {
                    filter = (Filter)tempChildFilter.get(0);
                } else {
                    filter.setChildFilterList(tempChildFilter);
                }
            }
        }
        return filter;
    }

    private Filter handleFilterJsonStr(FilterGroup filterGroup, Map<String, Object> stringObjectMap) {
        Filter filter = new Filter();
        filter.setFilterGroup(filterGroup);
        if (CollUtil.isNotEmpty(stringObjectMap)) {
            stringObjectMap.forEach((key, value) -> {
                if (ObjectUtil.isNotEmpty((Object)value)) {
                    if (this.checkValueSimple(value)) {
                        filter.addFilterBean((String)key, FilterOperational.$eq, value);
                    } else if (GROUP_ENUM_MAP.containsKey(key)) {
                        filter.addChildFilter(this.handleFilterJsonStr(GROUP_ENUM_MAP.get(key), (Map)value));
                    } else {
                        Map childMap = (Map)value;
                        childMap.forEach((op, childValue) -> {
                            FilterOperational filterOperational = OP_ENUM_MAP.get(op);
                            Assert.notNull((Object)((Object)filterOperational), (String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26\uff1a{}", (Object[])new Object[]{op});
                            filter.addFilterBean((String)key, filterOperational, childValue);
                        });
                    }
                }
            });
        }
        return filter;
    }

    private boolean checkValueSimple(Object value) {
        if (value instanceof String) {
            return true;
        }
        if (value instanceof Number) {
            return true;
        }
        return value instanceof Boolean;
    }

    private void groupHandle(QueryWrapper<?> queryWrapper, Filter filter) {
        FilterGroup filterGroup = filter.getFilterGroup();
        switch (filterGroup) {
            case $and: {
                queryWrapper.and(condition -> {
                    filter.getFilterBeanList().forEach(childFilterBean -> this.opHandle((QueryWrapper<?>)condition, (Filter.FilterBean)childFilterBean));
                    filter.getChildFilterList().forEach(childFilter -> this.groupHandle((QueryWrapper<?>)condition, (Filter)childFilter));
                });
                break;
            }
            case $or: {
                queryWrapper.or(condition -> {
                    filter.getFilterBeanList().forEach(childFilterBean -> this.opHandle((QueryWrapper<?>)condition, (Filter.FilterBean)childFilterBean));
                    filter.getChildFilterList().forEach(childFilter -> this.groupHandle((QueryWrapper<?>)condition, (Filter)childFilter));
                });
            }
        }
    }

    private void opHandle(QueryWrapper<?> queryWrapper, Filter.FilterBean filterBean) {
        FilterOperational filterOperational = OP_ENUM_MAP.get(filterBean.getOp());
        boolean notEmpty = StrUtil.isNotEmpty((CharSequence)filterBean.getValue().toString());
        switch (filterOperational) {
            case $eq: {
                queryWrapper.eq(notEmpty, (Object)filterBean.getFiled(), filterBean.getValue());
                break;
            }
            case $ne: {
                queryWrapper.ne(notEmpty, (Object)filterBean.getFiled(), filterBean.getValue());
                break;
            }
            case $like: {
                queryWrapper.like(notEmpty, (Object)filterBean.getFiled(), (Object)filterBean.getValue().toString());
                break;
            }
            case $in: {
                Collection value = (Collection)filterBean.getValue();
                queryWrapper.in(value.size() > 0, (Object)filterBean.getFiled(), value);
                break;
            }
            case $gt: {
                queryWrapper.gt(notEmpty, (Object)filterBean.getFiled(), filterBean.getValue());
                break;
            }
            case $ge: {
                queryWrapper.ge(notEmpty, (Object)filterBean.getFiled(), filterBean.getValue());
                break;
            }
            case $lt: {
                queryWrapper.lt(notEmpty, (Object)filterBean.getFiled(), filterBean.getValue());
                break;
            }
            case $le: {
                queryWrapper.le(notEmpty, (Object)filterBean.getFiled(), filterBean.getValue());
                break;
            }
            case $isNull: {
                queryWrapper.isNull(notEmpty, (Object)filterBean.getFiled());
            }
        }
    }
}

