/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.mapper.log;

import cn.miniants.framework.mapper.log.IOplogStorageProvider;
import cn.miniants.framework.mapper.log.Oplog;
import cn.miniants.framework.mapper.log.OplogContext;
import cn.miniants.framework.spring.SpringHelper;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class OplogAspect {
    private IOplogStorageProvider oplogStorageProvider;

    public OplogAspect(IOplogStorageProvider oplogStorageProvider) {
        this.oplogStorageProvider = oplogStorageProvider;
    }

    @Around(value="@within(org.springframework.web.bind.annotation.RestController)")
    public Object oplogAround(ProceedingJoinPoint pjp) throws Throwable {
        Object result;
        long beginTime = System.currentTimeMillis();
        Oplog oplog = OplogContext.builder().around(pjp.getSignature(), SpringHelper.getCurrentRequest(), pjp.getArgs());
        try {
            result = pjp.proceed();
            oplog.status(true);
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            this.oplogStorageProvider.save(pjp.getSignature(), oplog.build(System.currentTimeMillis() - beginTime));
            OplogContext.remove();
        }
        return result;
    }
}

