/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.interceptor;

import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.nacos.discovery.NacosDiscoveryClient;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class MiniFeignRequestInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MiniFeignRequestInterceptor.class);
    @Resource
    private NacosDiscoveryClient nacosDiscoveryClient;
    @Value(value="${miniants.feign.throw-on-host-miss:false}")
    private boolean throwOnHostMiss = false;
    @Value(value="${miniants.debug.gateway:}")
    private String debugGateway = null;

    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            String instanceHost;
            HttpServletRequest request = attributes.getRequest();
            String token = request.getHeader("Credentials");
            if (StrUtil.isNotBlank((CharSequence)token)) {
                requestTemplate.header("Credentials", new String[]{token});
            }
            String jwt = request.getHeader("Authorization");
            if (StrUtil.isNotBlank((CharSequence)token)) {
                requestTemplate.header("Authorization", new String[]{jwt});
            }
            if (StrUtil.isBlank((CharSequence)(instanceHost = request.getHeader("instance-host")))) {
                instanceHost = request.getParameter("instance-host");
            }
            if (StrUtil.isNotBlank((CharSequence)instanceHost)) {
                requestTemplate.header("instance-host", new String[]{instanceHost});
                String serviceName = requestTemplate.feignTarget().name();
                List instances = this.nacosDiscoveryClient.getInstances(serviceName);
                String finalInstanceHost = instanceHost;
                ServiceInstance selectedInstance = instances.stream().filter(instance -> finalInstanceHost.equals(instance.getHost())).findFirst().orElse(null);
                if (selectedInstance != null) {
                    String scheme = selectedInstance.getScheme() != null ? selectedInstance.getScheme() : "http";
                    String selectHostUrl = scheme + "://" + selectedInstance.getHost() + ":" + selectedInstance.getPort() + "/";
                    String selectServiceUrl = requestTemplate.feignTarget().url().replaceAll(scheme + "://[^/]*/?", selectHostUrl);
                    requestTemplate.target(selectServiceUrl);
                } else {
                    log.error("=====>FeignClient\u672a\u627e\u5230\u76ee\u6807\u5b9e\u4f8b[host:%s]\u6765\u8c03\u7528\u670d\u52a1:%s\uff0c\u5982\u679c\u4e0d\u662fNAT\u7684\u670d\u52a1\u6bb5\uff0c\u8bf7\u4e0d\u8981\u914d\u7f6eVIT\u4e2d\u7684VITE_PROXY_HEAD_INSTANCE_HOST\u53c2\u6570".formatted(instanceHost, serviceName));
                    if (this.throwOnHostMiss) {
                        throw new RuntimeException("FeignClient\u672a\u627e\u5230\u76ee\u6807\u5b9e\u4f8b[host:%s]\u6765\u8c03\u7528\u670d\u52a1:%s".formatted(instanceHost, serviceName));
                    }
                }
            }
        }
    }
}

