/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.web;

import cn.hutool.core.lang.Assert;
import cn.miniants.framework.spring.SpringHelper;
import cn.miniants.framework.token.StormwindToken;
import cn.miniants.framework.token.TokenUserType;
import cn.miniants.toolkit.JSONUtil;
import cn.miniants.toolkit.MiniStrUtil;
import cn.miniants.toolkit.ThreadLocalUtils;
import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.security.token.SSOToken;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class UserSession {
    private JsonNode originalData;
    private Long id;
    private String username;
    private String realName;
    private String nickName;
    private String authorities;
    private String scope;
    private String clientId;
    private String userPayload;
    private TokenUserType userType;
    private List<Map<String, ?>> principals;

    public String pathValue(String fieldPath) {
        return MiniStrUtil.getOrEmpty((Object)JSONUtil.pathReadNestedValue((JsonNode)this.originalData, (String)fieldPath));
    }

    public static Optional<UserSession> getLoginInfoOpt() {
        return Optional.ofNullable(UserSession.getCurSession(SpringHelper.getCurrentRequest(), true));
    }

    public static UserSession getCurSession() {
        return UserSession.getCurSession(SpringHelper.getCurrentRequest(), false);
    }

    public static <T> T getUserPayload(Class<T> clazz) {
        return (T)JSONUtil.parse((String)UserSession.getCurSession().getUserPayload(), clazz);
    }

    private static UserSession getCurSession(HttpServletRequest request, boolean allowNull) {
        UserSession userSession = (UserSession)ThreadLocalUtils.get((String)"UserSession");
        if (null != userSession) {
            return userSession;
        }
        StormwindToken ssoToken = UserSession.getSSOToken(request, allowNull);
        userSession = Optional.ofNullable(ssoToken).map(ssoToken1 -> UserSession.builder().id(Long.valueOf(ssoToken1.getId())).username(ssoToken1.getIssuer()).userType(ssoToken1.getUserType()).build()).orElse(null);
        ThreadLocalUtils.put((String)"UserSession", (Object)userSession);
        return userSession;
    }

    public static StormwindToken getSSOToken(HttpServletRequest request, boolean allowNull) {
        StormwindToken ssoToken = UserSession.getSSOToken(request);
        Assert.isFalse((null == ssoToken && !allowNull ? 1 : 0) != 0, (String)"\u672a\u767b\u5f55", (Object[])new Object[0]);
        return ssoToken;
    }

    private static StormwindToken getSSOToken(HttpServletRequest request) {
        SSOToken ssoToken = null;
        if (null != request && null == (ssoToken = SSOHelper.attrToken((HttpServletRequest)request))) {
            ssoToken = SSOHelper.getSSOToken((HttpServletRequest)request);
        }
        return StormwindToken.parser(ssoToken);
    }

    public static boolean isAdmin(Long id) {
        return Objects.equals(0L, id);
    }

    UserSession(JsonNode originalData, Long id, String username, String realName, String nickName, String authorities, String scope, String clientId, String userPayload, TokenUserType userType, List<Map<String, ?>> principals) {
        this.originalData = originalData;
        this.id = id;
        this.username = username;
        this.realName = realName;
        this.nickName = nickName;
        this.authorities = authorities;
        this.scope = scope;
        this.clientId = clientId;
        this.userPayload = userPayload;
        this.userType = userType;
        this.principals = principals;
    }

    public static UserSessionBuilder builder() {
        return new UserSessionBuilder();
    }

    public JsonNode getOriginalData() {
        return this.originalData;
    }

    public Long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getAuthorities() {
        return this.authorities;
    }

    public String getScope() {
        return this.scope;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUserPayload() {
        return this.userPayload;
    }

    public TokenUserType getUserType() {
        return this.userType;
    }

    public List<Map<String, ?>> getPrincipals() {
        return this.principals;
    }

    public void setOriginalData(JsonNode originalData) {
        this.originalData = originalData;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setAuthorities(String authorities) {
        this.authorities = authorities;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setUserPayload(String userPayload) {
        this.userPayload = userPayload;
    }

    public void setUserType(TokenUserType userType) {
        this.userType = userType;
    }

    public void setPrincipals(List<Map<String, ?>> principals) {
        this.principals = principals;
    }

    public static class UserSessionBuilder {
        private JsonNode originalData;
        private Long id;
        private String username;
        private String realName;
        private String nickName;
        private String authorities;
        private String scope;
        private String clientId;
        private String userPayload;
        private TokenUserType userType;
        private List<Map<String, ?>> principals;

        UserSessionBuilder() {
        }

        public UserSessionBuilder originalData(JsonNode originalData) {
            this.originalData = originalData;
            return this;
        }

        public UserSessionBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public UserSessionBuilder username(String username) {
            this.username = username;
            return this;
        }

        public UserSessionBuilder realName(String realName) {
            this.realName = realName;
            return this;
        }

        public UserSessionBuilder nickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public UserSessionBuilder authorities(String authorities) {
            this.authorities = authorities;
            return this;
        }

        public UserSessionBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public UserSessionBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public UserSessionBuilder userPayload(String userPayload) {
            this.userPayload = userPayload;
            return this;
        }

        public UserSessionBuilder userType(TokenUserType userType) {
            this.userType = userType;
            return this;
        }

        public UserSessionBuilder principals(List<Map<String, ?>> principals) {
            this.principals = principals;
            return this;
        }

        public UserSession build() {
            return new UserSession(this.originalData, this.id, this.username, this.realName, this.nickName, this.authorities, this.scope, this.clientId, this.userPayload, this.userType, this.principals);
        }

        public String toString() {
            return "UserSession.UserSessionBuilder(originalData=" + this.originalData + ", id=" + this.id + ", username=" + this.username + ", realName=" + this.realName + ", nickName=" + this.nickName + ", authorities=" + this.authorities + ", scope=" + this.scope + ", clientId=" + this.clientId + ", userPayload=" + this.userPayload + ", userType=" + this.userType + ", principals=" + this.principals + ")";
        }
    }
}

