/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.security;

import cn.miniants.framework.web.UserSession;
import cn.miniants.toolkit.JSONUtil;
import cn.miniants.toolkit.ThreadLocalUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@ConditionalOnProperty(prefix="miniants.auth", name={"enabled"}, havingValue="true")
@Component
public class ServiceAuthFilter
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String jwt_credentials = request.getHeader("Credentials");
        if (null != jwt_credentials) {
            String jwt_credentials_json = new String(Base64.getDecoder().decode(jwt_credentials), StandardCharsets.UTF_8);
            JsonNode jwtObject = JSONUtil.readTree((String)jwt_credentials_json);
            ThreadLocalUtils.put((String)"UserSession", (Object)UserSession.builder().originalData(jwtObject).principals(null == jwtObject.get("principals") ? null : JSONUtil.readList((JsonNode)jwtObject.get("principals"))).username(null == jwtObject.get("username") ? null : jwtObject.get("username").asText()).realName(null == jwtObject.get("realName") ? null : jwtObject.get("realName").asText()).nickName(null == jwtObject.get("nickName") ? null : jwtObject.get("nickName").asText()).authorities(null == jwtObject.get("authorities") ? null : jwtObject.get("authorities").asText()).id(null == jwtObject.get("userId") ? null : Long.valueOf(jwtObject.get("userId").asLong())).clientId(null == jwtObject.get("clientId") ? null : jwtObject.get("clientId").asText()).build());
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ThreadLocalUtils.remove((String)"UserSession");
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }
}

