/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.autoconfigure;

import cn.hutool.core.collection.CollUtil;
import cn.miniants.framework.mapper.MiniSqlInjector;
import cn.miniants.framework.web.AizudaMetaObjectHandler;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Lazy
@EnableTransactionManagement
@Configuration(proxyBeanMethods=false)
public class MybatisPlusConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusInterceptor mybatisPlusInterceptor(@Autowired(required=false) List<InnerInterceptor> innerInterceptorList) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (CollUtil.isNotEmpty(innerInterceptorList)) {
            innerInterceptorList.forEach(arg_0 -> ((MybatisPlusInterceptor)interceptor).addInnerInterceptor(arg_0));
        }
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.MYSQL));
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public MiniSqlInjector batchSqlInjector() {
        return new MiniSqlInjector();
    }

    @Bean
    @ConditionalOnMissingBean(value={MetaObjectHandler.class})
    public AizudaMetaObjectHandler metaObjectHandler() {
        return new AizudaMetaObjectHandler();
    }
}

