/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.pagesqlhandle.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.miniants.framework.pagesqlhandle.order.Order;
import cn.miniants.framework.pagesqlhandle.order.OrderOption;
import cn.miniants.toolkit.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OrderHandlerUtil {
    private static final LinkedHashMap<String, OrderOption> ORDER_OPTION_MAP = EnumUtil.getEnumMap(OrderOption.class);
    private String orderStr;
    private List<Order> orderList;

    public OrderHandlerUtil(String orderStr) {
        if (StrUtil.isNotEmpty((CharSequence)orderStr)) {
            if (!cn.hutool.json.JSONUtil.isTypeJSON((String)orderStr)) {
                orderStr = URLUtil.decode((String)orderStr);
            }
            this.orderStr = orderStr;
            this.orderList = this.handleOrderJsonStr(orderStr);
        }
    }

    public Wrapper handelWrapperOrder(QueryWrapper wrapper) {
        if (ObjectUtil.isNull((Object)wrapper)) {
            wrapper = Wrappers.emptyWrapper();
        }
        if (CollUtil.isNotEmpty(this.orderList)) {
            this.orderListHandle(wrapper, this.orderList);
        }
        return wrapper;
    }

    private List<Order> handleOrderJsonStr(String orderStr) {
        LinkedList<Order> orderList = new LinkedList<Order>();
        Map stringObjectMap = JSONUtil.readMap((String)orderStr);
        Assert.notNull((Object)stringObjectMap, (String)"order \u5b57\u6bb5\u9519\u8bef\uff01", (Object[])new Object[0]);
        stringObjectMap.forEach((key, value) -> {
            if (!StrUtil.isEmptyIfStr((Object)value)) {
                Assert.isTrue((boolean)ORDER_OPTION_MAP.containsKey(value.toString()), (String)"order \u5b57\u6bb5\u9519\u8bef\uff01\u3010ASC,DESC\u3011", (Object[])new Object[0]);
                orderList.add(new Order(StringUtils.camelToUnderline((String)key), value.toString()));
            }
        });
        return orderList;
    }

    private void orderListHandle(QueryWrapper<?> queryWrapper, List<Order> orderList) {
        orderList.forEach(order -> {
            OrderOption orderOption = ORDER_OPTION_MAP.get(order.getOrder());
            switch (orderOption) {
                case ASC: {
                    queryWrapper.orderByAsc((Object)order.getFiled());
                    break;
                }
                case DESC: {
                    queryWrapper.orderByDesc((Object)order.getFiled());
                }
            }
        });
    }
}

