/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.advice;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.miniants.framework.advice.MiniControllerResult;
import cn.miniants.framework.api.ApiResult;
import cn.miniants.framework.api.IErrorCode;
import cn.miniants.framework.exception.ApiException;
import cn.miniants.framework.exception.MiniFeignException;
import cn.miniants.framework.spring.SpringHelper;
import cn.miniants.toolkit.JSONUtil;
import feign.FeignException;
import io.jsonwebtoken.JwtException;
import java.io.EOFException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.apache.catalina.connector.ClientAbortException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.springframework.web.util.NestedServletException;

@RestControllerAdvice
public class MiniControllerResultAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(MiniControllerResultAdvice.class);

    public boolean supports(@NotNull MethodParameter returnType, @NotNull Class converterType) {
        Method m = returnType.getMethod();
        return m != null && m.getReturnType() != Void.TYPE;
    }

    public Object beforeBodyWrite(Object body, @NotNull MethodParameter returnType, @NotNull MediaType selectedContentType, @NotNull Class selectedConverterType, @NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response) {
        MiniControllerResult myAnnotation;
        response.getHeaders().add("Mini-Api", "true");
        if (body instanceof ApiResult) {
            return body;
        }
        Method method = returnType.getMethod();
        if (method != null && (myAnnotation = method.getAnnotation(MiniControllerResult.class)) != null && myAnnotation.skipWrapper()) {
            return body;
        }
        ApiResult<Object> apiResult = ApiResult.ok(body);
        if (returnType.getParameterType().isAssignableFrom(String.class)) {
            return JSONUtil.toJSONString(apiResult);
        }
        return apiResult;
    }

    @ExceptionHandler(value={Exception.class})
    public ApiResult<Object> handleException(Exception ex, HttpServletResponse resp, HttpServletRequest req) {
        return MiniControllerResultAdvice.handleBadRequest(ex, resp, req);
    }

    private static String convertFiledErrors(List<FieldError> fieldErrors) {
        return Optional.ofNullable(fieldErrors).map(fieldErrorsInner -> fieldErrorsInner.stream().flatMap(fieldError -> Stream.of(fieldError.getField() + " " + fieldError.getDefaultMessage())).collect(Collectors.joining(", "))).orElse(null);
    }

    private static String convertConstraintViolationsToMessage(ConstraintViolationException constraintViolationException) {
        return Optional.ofNullable(constraintViolationException.getConstraintViolations()).map(constraintViolations -> constraintViolations.stream().flatMap(constraintViolation -> {
            String path = constraintViolation.getPropertyPath().toString();
            String errorMessage = path.substring(path.lastIndexOf(".") + 1) + " " + constraintViolation.getMessage();
            return Stream.of(errorMessage);
        }).collect(Collectors.joining(", "))).orElse(null);
    }

    private static boolean isOAuth2ExceptionLoaded() {
        try {
            Class.forName("org.springframework.security.oauth2.common.exceptions.OAuth2Exception");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isOAuth2Exception(Throwable e) {
        try {
            Class<?> oAuth2ExceptionClass = Class.forName("org.springframework.security.oauth2.common.exceptions.OAuth2Exception");
            return oAuth2ExceptionClass.isInstance(e);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static boolean isClientAbort(Throwable e) {
        Throwable root = ExceptionUtil.getRootCause((Throwable)e);
        Throwable t = root != null ? root : e;
        String msg = (t.getMessage() == null ? "" : t.getMessage()).toLowerCase();
        return t instanceof ClientAbortException || t instanceof EOFException || msg.contains("broken pipe") || msg.contains("connection reset by peer") || msg.contains("connection reset");
    }

    private static Throwable unwrapNested(Throwable e) {
        if (e instanceof NestedServletException && e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }

    public static ApiResult<Object> handleBadRequest(Exception ex, HttpServletResponse resp, HttpServletRequest req) {
        Throwable e = MiniControllerResultAdvice.unwrapNested(ex);
        if (null == resp || resp.isCommitted() || MiniControllerResultAdvice.isClientAbort(e)) {
            if (null != resp && !resp.isCommitted()) {
                resp.setStatus(204);
            }
            log.warn("[SERVICE-API][CLIENT-ABORT] {} {} -> {}", new Object[]{req.getMethod(), req.getRequestURI(), e.getMessage()});
            return null;
        }
        String _str = "[SERVICE-API][{}] ip=%-15s xff=%-15s %-6s {} %s".formatted(req.getRemoteAddr(), req.getHeader("X-Forwarded-For"), req.getMethod(), req.getRequestURI());
        if (e instanceof ApiException) {
            log.warn(_str, (Object)"ApiException", (Object)e.getMessage());
            IErrorCode errorCode = ((ApiException)e).getErrorCode();
            return null != errorCode ? ApiResult.failed(errorCode) : ApiResult.failed(e.getMessage());
        }
        if (e instanceof IllegalArgumentException) {
            log.warn(_str, (Object)"IllegalArgumentException", (Object)e.getMessage());
            resp.setStatus(400);
            return ApiResult.failed(e.getMessage());
        }
        if (e instanceof ConstraintViolationException) {
            log.warn(_str, (Object)"ConstraintViolationException", (Object)e.getMessage());
            resp.setStatus(400);
            return ApiResult.failed(MiniControllerResultAdvice.convertConstraintViolationsToMessage((ConstraintViolationException)e));
        }
        if (e instanceof BindException) {
            log.warn(_str, (Object)"BindException", (Object)e.getMessage());
            ApiResult<Object> res = ApiResult.failed(MiniControllerResultAdvice.convertFiledErrors(((BindException)e).getBindingResult().getFieldErrors()));
            if (SpringHelper.isValidationControllerMethod()) {
                resp.setStatus(200);
                res.setCode(201L);
            }
            return res;
        }
        if (e instanceof MiniFeignException) {
            log.warn(_str, (Object)"MiniFeignException", (Object)e.getMessage());
            resp.setStatus(((MiniFeignException)e).getErrorCode());
            ApiResult<Object> res = ApiResult.failed(e.getMessage());
            res.setErrorDetails(((MiniFeignException)e).getFeignTraceMessage());
            return res;
        }
        if (e instanceof FeignException) {
            log.warn(_str, (Object)"FeignException", (Object)e.getMessage());
            resp.setStatus(500);
            ApiResult<Object> res = ApiResult.failed(e.getMessage());
            return res;
        }
        if (e instanceof JwtException) {
            log.warn(_str, (Object)"JwtException", (Object)e.getMessage());
            resp.setStatus(400);
            return ApiResult.failed("JWT token \u5f02\u5e38");
        }
        if (MiniControllerResultAdvice.isOAuth2ExceptionLoaded() && MiniControllerResultAdvice.isOAuth2Exception(e)) {
            log.warn(_str, (Object)"OAuth2Exception", (Object)e.getMessage());
            OAuth2Exception oAuth2Ex = (OAuth2Exception)e;
            resp.setStatus(oAuth2Ex.getHttpErrorCode());
            return ApiResult.failed(oAuth2Ex.getMessage());
        }
        log.warn(_str, (Object)"Unknown exception", (Object)e.getMessage());
        resp.setStatus(503);
        ApiResult<Object> res = ApiResult.failed("Service Error:%s".formatted(e.getMessage()));
        log.error("Service Error: {}", (Object)ExceptionUtil.stacktraceToString((Throwable)e));
        return res;
    }
}

