
package cn.miniants.framework.exception;

import cn.miniants.framework.api.IErrorCode;
import lombok.extern.slf4j.Slf4j;

import java.io.PrintWriter;
import java.io.StringWriter;


@Slf4j
public class ApiException extends RuntimeException {
    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -5885155226898287919L;
    /**
     * 错误码
     */
    private IErrorCode errorCode;

    public ApiException(IErrorCode errorCode) {
        super(errorCode.getMsg());
        this.errorCode = errorCode;
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(Throwable cause) {
        super(cause);
    }

    public ApiException(String message, Throwable cause) {
        super(message, cause);
    }

    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public IErrorCode getErrorCode() {
        return errorCode;
    }
}
