/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.mybatistype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoPointConverter {
    private static final Logger log = LoggerFactory.getLogger(GeoPointConverter.class);
    private final int byteOrder = 2;
    private final PrecisionModel precisionModel = new PrecisionModel();
    private int outputDimension = 2;

    public org.springframework.data.geo.Point from(byte[] bytes) {
        org.springframework.data.geo.Point point;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            byte[] sridBytes = new byte[4];
            inputStream.read(sridBytes);
            int srid = ByteOrderValues.getInt((byte[])sridBytes, (int)2);
            GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, srid);
            WKBReader wkbReader = new WKBReader(geometryFactory);
            Geometry geometry = wkbReader.read((InStream)new InputStreamInStream((InputStream)inputStream));
            Point point2 = (Point)geometry;
            point = new org.springframework.data.geo.Point(point2.getY(), point2.getX());
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParseException e) {
                log.error("\u5730\u7406\u4f4d\u7f6e\u8f6c\u6362\u9519\u8bef");
                throw new IllegalArgumentException(e);
            }
        }
        inputStream.close();
        return point;
    }

    public byte[] to(org.springframework.data.geo.Point geoPoint) {
        byte[] byArray;
        if (geoPoint == null) {
            return null;
        }
        Coordinate coordinate = new Coordinate(geoPoint.getY(), geoPoint.getX());
        CoordinateArraySequence coordinateArraySequence = new CoordinateArraySequence(new Coordinate[]{coordinate}, 2);
        Point point = new Point((CoordinateSequence)coordinateArraySequence, new GeometryFactory());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            byte[] sridBytes = new byte[4];
            ByteOrderValues.putInt((int)point.getSRID(), (byte[])sridBytes, (int)2);
            outputStream.write(sridBytes);
            WKBWriter wkbWriter = new WKBWriter(this.outputDimension, 2);
            wkbWriter.write((Geometry)point, (OutStream)new OutputStreamOutStream((OutputStream)outputStream));
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                log.error("\u5730\u7406\u4f4d\u7f6e\u8f6c\u6362\u9519\u8bef");
                throw new IllegalArgumentException(ioe);
            }
        }
        outputStream.close();
        return byArray;
    }
}

