/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.interceptor;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.SystemClock;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class PerformanceInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(PerformanceInterceptor.class);
    private long maxTime = 0L;
    private boolean format = false;
    private boolean writeInLog = true;
    private static final SqlFormatter sqlFormatter = new SqlFormatter();

    public Object intercept(Invocation invocation) throws Throwable {
        int index;
        String originalSql;
        Object firstArg = invocation.getArgs()[0];
        Statement statement = Proxy.isProxyClass(firstArg.getClass()) ? (Statement)SystemMetaObject.forObject((Object)firstArg).getValue("h.statement") : (Statement)firstArg;
        MetaObject stmtMetaObj = SystemMetaObject.forObject((Object)statement);
        try {
            statement = (Statement)stmtMetaObj.getValue("stmt.statement");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stmtMetaObj.hasGetter("delegate")) {
            try {
                statement = (Statement)stmtMetaObj.getValue("delegate");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((originalSql = null) == null) {
            originalSql = statement.toString();
        }
        if ((index = this.indexOfSqlStart(originalSql = originalSql.replaceAll("[\\s]+", " "))) > 0) {
            originalSql = originalSql.substring(index);
        }
        long start = SystemClock.now();
        Object result = invocation.proceed();
        long timing = SystemClock.now() - start;
        Object target = PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)target);
        MappedStatement ms = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        StringBuilder formatSql = new StringBuilder();
        formatSql.append(" Time\uff1a").append(timing);
        formatSql.append(" ms - ID\uff1a").append(ms.getId());
        formatSql.append("\n Execute SQL\uff1a").append(PerformanceInterceptor.sqlFormat(originalSql, this.format)).append("\n");
        if (this.isWriteInLog()) {
            if (this.getMaxTime() >= 1L && timing > this.getMaxTime()) {
                log.error(formatSql.toString());
            } else {
                log.info(formatSql.toString());
            }
        } else {
            System.err.println(formatSql);
            if (this.getMaxTime() >= 1L && timing > this.getMaxTime()) {
                throw new RuntimeException(" The SQL execution time is too large, please optimize ! ");
            }
        }
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
        String maxTime = prop.getProperty("maxTime");
        String format = prop.getProperty("format");
        if (StringUtils.isNotEmpty((CharSequence)maxTime)) {
            this.maxTime = Long.parseLong(maxTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)format)) {
            this.format = Boolean.valueOf(format);
        }
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public PerformanceInterceptor setMaxTime(long maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    public boolean isFormat() {
        return this.format;
    }

    public PerformanceInterceptor setFormat(boolean format) {
        this.format = format;
        return this;
    }

    public boolean isWriteInLog() {
        return this.writeInLog;
    }

    public PerformanceInterceptor setWriteInLog(boolean writeInLog) {
        this.writeInLog = writeInLog;
        return this;
    }

    public Method getMethodRegular(Class<?> clazz, String methodName) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return this.getMethodRegular(clazz.getSuperclass(), methodName);
    }

    private int indexOfSqlStart(String sql) {
        String upperCaseSql = sql.toUpperCase();
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(upperCaseSql.indexOf("SELECT "));
        set.add(upperCaseSql.indexOf("UPDATE "));
        set.add(upperCaseSql.indexOf("INSERT "));
        set.add(upperCaseSql.indexOf("DELETE "));
        set.remove(-1);
        if (CollectionUtils.isEmpty(set)) {
            return -1;
        }
        ArrayList list = new ArrayList(set);
        Collections.sort(list, Integer::compareTo);
        return (Integer)list.get(0);
    }

    public static String sqlFormat(String boundSql, boolean format) {
        if (format) {
            try {
                return sqlFormatter.format(boundSql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boundSql;
    }

    static class SqlFormatter {
        public static final String WHITESPACE = " \n\r\f\t";
        private static final Set<String> BEGIN_CLAUSES = new HashSet<String>();
        private static final Set<String> END_CLAUSES = new HashSet<String>();
        private static final Set<String> LOGICAL = new HashSet<String>();
        private static final Set<String> QUANTIFIERS = new HashSet<String>();
        private static final Set<String> DML = new HashSet<String>();
        private static final Set<String> MISC = new HashSet<String>();
        private static final String INDENT_STRING = "    ";
        private static final String INITIAL = "\n    ";

        SqlFormatter() {
        }

        public String format(String source) {
            return new FormatProcess(source).perform();
        }

        static {
            BEGIN_CLAUSES.add("left");
            BEGIN_CLAUSES.add("right");
            BEGIN_CLAUSES.add("inner");
            BEGIN_CLAUSES.add("outer");
            BEGIN_CLAUSES.add("group");
            BEGIN_CLAUSES.add("order");
            END_CLAUSES.add("where");
            END_CLAUSES.add("set");
            END_CLAUSES.add("having");
            END_CLAUSES.add("join");
            END_CLAUSES.add("from");
            END_CLAUSES.add("by");
            END_CLAUSES.add("join");
            END_CLAUSES.add("into");
            END_CLAUSES.add("union");
            LOGICAL.add("and");
            LOGICAL.add("or");
            LOGICAL.add("when");
            LOGICAL.add("else");
            LOGICAL.add("end");
            QUANTIFIERS.add("in");
            QUANTIFIERS.add("all");
            QUANTIFIERS.add("exists");
            QUANTIFIERS.add("some");
            QUANTIFIERS.add("any");
            DML.add("insert");
            DML.add("update");
            DML.add("delete");
            MISC.add("select");
            MISC.add("on");
        }

        private static class FormatProcess {
            boolean beginLine = true;
            boolean afterBeginBeforeEnd;
            boolean afterByOrSetOrFromOrSelect;
            boolean afterValues;
            boolean afterOn;
            boolean afterBetween;
            boolean afterInsert;
            int inFunction;
            int parensSinceSelect;
            private LinkedList<Integer> parenCounts = new LinkedList();
            private LinkedList<Boolean> afterByOrFromOrSelects = new LinkedList();
            int indent = 1;
            StringBuilder result = new StringBuilder();
            StringTokenizer tokens;
            String lastToken;
            String token;
            String lcToken;

            public FormatProcess(String sql) {
                this.tokens = new StringTokenizer(sql, "()+*/-=<>'`\"[], \n\r\f\t", true);
            }

            public String perform() {
                this.result.append(SqlFormatter.INITIAL);
                while (this.tokens.hasMoreTokens()) {
                    this.token = this.tokens.nextToken();
                    this.lcToken = this.token.toLowerCase(Locale.ROOT);
                    if ("'".equals(this.token)) {
                        t = "";
                        do {
                            try {
                                t = this.tokens.nextToken();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.token = this.token + t;
                        } while (!"'".equals(t) && this.tokens.hasMoreTokens());
                    } else if ("\"".equals(this.token)) {
                        do {
                            t = this.tokens.nextToken();
                            this.token = this.token + t;
                        } while (!"\"".equals(t));
                    }
                    if (this.afterByOrSetOrFromOrSelect && ",".equals(this.token)) {
                        this.commaAfterByOrFromOrSelect();
                    } else if (this.afterOn && ",".equals(this.token)) {
                        this.commaAfterOn();
                    } else if ("(".equals(this.token)) {
                        this.openParen();
                    } else if (")".equals(this.token)) {
                        this.closeParen();
                    } else if (BEGIN_CLAUSES.contains(this.lcToken)) {
                        this.beginNewClause();
                    } else if (END_CLAUSES.contains(this.lcToken)) {
                        this.endNewClause();
                    } else if ("select".equals(this.lcToken)) {
                        this.select();
                    } else if (DML.contains(this.lcToken)) {
                        this.updateOrInsertOrDelete();
                    } else if ("values".equals(this.lcToken)) {
                        this.values();
                    } else if ("on".equals(this.lcToken)) {
                        this.on();
                    } else if (this.afterBetween && this.lcToken.equals("and")) {
                        this.misc();
                        this.afterBetween = false;
                    } else if (LOGICAL.contains(this.lcToken)) {
                        this.logical();
                    } else if (FormatProcess.isWhitespace(this.token)) {
                        this.white();
                    } else {
                        this.misc();
                    }
                    if (FormatProcess.isWhitespace(this.token)) continue;
                    this.lastToken = this.lcToken;
                }
                return this.result.toString();
            }

            private void commaAfterOn() {
                this.out();
                --this.indent;
                this.newline();
                this.afterOn = false;
                this.afterByOrSetOrFromOrSelect = true;
            }

            private void commaAfterByOrFromOrSelect() {
                this.out();
                this.newline();
            }

            private void logical() {
                if ("end".equals(this.lcToken)) {
                    --this.indent;
                }
                this.newline();
                this.out();
                this.beginLine = false;
            }

            private void on() {
                ++this.indent;
                this.afterOn = true;
                this.newline();
                this.out();
                this.beginLine = false;
            }

            private void misc() {
                this.out();
                if ("between".equals(this.lcToken)) {
                    this.afterBetween = true;
                }
                if (this.afterInsert) {
                    this.newline();
                    this.afterInsert = false;
                } else {
                    this.beginLine = false;
                    if ("case".equals(this.lcToken)) {
                        ++this.indent;
                    }
                }
            }

            private void white() {
                if (!this.beginLine) {
                    this.result.append(" ");
                }
            }

            private void updateOrInsertOrDelete() {
                this.out();
                ++this.indent;
                this.beginLine = false;
                if ("update".equals(this.lcToken)) {
                    this.newline();
                }
                if ("insert".equals(this.lcToken)) {
                    this.afterInsert = true;
                }
            }

            private void select() {
                this.out();
                ++this.indent;
                this.newline();
                this.parenCounts.addLast(this.parensSinceSelect);
                this.afterByOrFromOrSelects.addLast(this.afterByOrSetOrFromOrSelect);
                this.parensSinceSelect = 0;
                this.afterByOrSetOrFromOrSelect = true;
            }

            private void out() {
                this.result.append(this.token);
            }

            private void endNewClause() {
                if (!this.afterBeginBeforeEnd) {
                    --this.indent;
                    if (this.afterOn) {
                        --this.indent;
                        this.afterOn = false;
                    }
                    this.newline();
                }
                this.out();
                if (!"union".equals(this.lcToken)) {
                    ++this.indent;
                }
                this.newline();
                this.afterBeginBeforeEnd = false;
                this.afterByOrSetOrFromOrSelect = "by".equals(this.lcToken) || "set".equals(this.lcToken) || "from".equals(this.lcToken);
            }

            private void beginNewClause() {
                if (!this.afterBeginBeforeEnd) {
                    if (this.afterOn) {
                        --this.indent;
                        this.afterOn = false;
                    }
                    --this.indent;
                    this.newline();
                }
                this.out();
                this.beginLine = false;
                this.afterBeginBeforeEnd = true;
            }

            private void values() {
                --this.indent;
                this.newline();
                this.out();
                ++this.indent;
                this.newline();
                this.afterValues = true;
            }

            private void closeParen() {
                --this.parensSinceSelect;
                if (this.parensSinceSelect < 0) {
                    --this.indent;
                    this.parensSinceSelect = this.parenCounts.removeLast();
                    this.afterByOrSetOrFromOrSelect = this.afterByOrFromOrSelects.removeLast();
                }
                if (this.inFunction > 0) {
                    --this.inFunction;
                    this.out();
                } else {
                    if (!this.afterByOrSetOrFromOrSelect) {
                        --this.indent;
                        this.newline();
                    }
                    this.out();
                }
                this.beginLine = false;
            }

            private void openParen() {
                if (FormatProcess.isFunctionName(this.lastToken) || this.inFunction > 0) {
                    ++this.inFunction;
                }
                this.beginLine = false;
                if (this.inFunction > 0) {
                    this.out();
                } else {
                    this.out();
                    if (!this.afterByOrSetOrFromOrSelect) {
                        ++this.indent;
                        this.newline();
                        this.beginLine = true;
                    }
                }
                ++this.parensSinceSelect;
            }

            private static boolean isFunctionName(String tok) {
                char begin = tok.charAt(0);
                boolean isIdentifier = Character.isJavaIdentifierStart(begin) || '\"' == begin;
                return isIdentifier && !LOGICAL.contains(tok) && !END_CLAUSES.contains(tok) && !QUANTIFIERS.contains(tok) && !DML.contains(tok) && !MISC.contains(tok);
            }

            private static boolean isWhitespace(String token) {
                return SqlFormatter.WHITESPACE.contains(token);
            }

            private void newline() {
                this.result.append("\n");
                for (int i = 0; i < this.indent; ++i) {
                    this.result.append(SqlFormatter.INDENT_STRING);
                }
                this.beginLine = true;
            }
        }
    }
}

