/*
 * Decompiled with CFR 0.152.
 */
package cn.miniants.framework.advice;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.miniants.framework.exception.MiniFeignException;
import cn.miniants.toolkit.JSONUtil;
import com.fasterxml.jackson.databind.JsonNode;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.stream.Collectors;

public class MiniFeignErrorDecoder
implements ErrorDecoder {
    private final ErrorDecoder defaultErrorDecoder = new ErrorDecoder.Default();

    public Exception decode(String methodKey, Response response) {
        boolean isMiniApi;
        boolean bl = isMiniApi = ObjectUtil.isNotNull(response.headers().get("Mini-Api")) && ((Collection)response.headers().get("Mini-Api")).stream().anyMatch(value -> value.contains("true"));
        if (isMiniApi) {
            String responseBody;
            String importMsg = "=====>FeignClient\u8fd4\u56de\u5f02\u5e38\uff1a%s--->%s:".formatted(response.request().url(), methodKey);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.body().asInputStream()));){
                responseBody = reader.lines().collect(Collectors.joining("\n"));
            }
            catch (IOException e) {
                throw new MiniFeignException(503, "\u8bfb\u53d6\u54cd\u5e94\u4f53\u5931\u8d25", importMsg);
            }
            int code = response.status();
            String message = response.reason();
            if (StrUtil.isNotBlank((CharSequence)responseBody)) {
                JsonNode resp = JSONUtil.readTree((String)responseBody);
                if (null != resp.get("message")) {
                    message = resp.get("message").asText();
                }
                throw new MiniFeignException(code, message, importMsg);
            }
            return this.defaultErrorDecoder.decode(methodKey, response);
        }
        return this.defaultErrorDecoder.decode(methodKey, response);
    }
}

