/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.wechat.config;

import cn.remex.RemexConstants;
import cn.remex.core.util.Assert;
import cn.remex.core.util.FileHelper;
import cn.remex.core.util.JsonHelper;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.Param;
import cn.remex.db.Database;
import cn.remex.web.service.BsException;
import cn.remex.wechat.WeChat;
import cn.remex.wechat.beans.WeChatUserOpenIdList;
import cn.remex.wechat.beans.messages.CustomMsg;
import cn.remex.wechat.beans.messages.CustomMsgData;
import cn.remex.wechat.beans.messages.TemplateMessage;
import cn.remex.wechat.beans.messages.WeChactMessageResult;
import cn.remex.wechat.beans.paymch.WeChatPayResult;
import cn.remex.wechat.beans.paymch.WeChatUnifiedorder;
import cn.remex.wechat.beans.paymch.WeChatUnifiedorderResult;
import cn.remex.wechat.config.WeChatApp;
import cn.remex.wechat.models.WeChatMsg;
import cn.remex.wechat.models.WeChatTemplateMessage;
import java.io.File;
import java.util.UUID;
import java.util.function.Consumer;

public class WeChatAppExt {
    private WeChatApp weChatApp;

    public WeChatAppExt(WeChatApp weChatApp) {
        this.weChatApp = weChatApp;
    }

    public WeChatApp getWeChatApp() {
        return this.weChatApp;
    }

    public void setWeChatApp(WeChatApp weChatApp) {
        this.weChatApp = weChatApp;
    }

    public WeChatPayResult pay(String desc, String orderId, String money, String openId, String payType) {
        WeChatUnifiedorderResult weChatUnifiedorderResult;
        Assert.notNullAndEmpty(this.weChatApp.getMchid(), "FAIL", "\u6ca1\u6709\u914d\u7f6e\u5fae\u4fe1\u652f\u4ed8\u5546\u6237\u8d26\u6237\u4fe1\u606f");
        payType = Judgment.nullOrBlank(payType) ? "JSAPI" : payType;
        Assert.isTrue("JSAPI;NATIVE;APP".contains(payType), "FAIL", "\u652f\u4ed8\u7c7b\u578b\u53ea\u80fd\u4e3aJSAPI--\u516c\u4f17\u53f7\u652f\u4ed8\u3001NATIVE--\u539f\u751f\u626b\u7801\u652f\u4ed8\u3001APP--app\u652f\u4ed8");
        RemexConstants.logger.info((Object)("\u5fae\u4fe1\u4ed8\u6b3e\uff1a" + desc + "\u91d1\u989d\uff1a" + money));
        WeChatUnifiedorder weChatUnifiedorder = new WeChatUnifiedorder();
        weChatUnifiedorder.setAppid(WeChat.getWeChatApp().getAppid());
        weChatUnifiedorder.setMch_id(this.weChatApp.getMchid());
        weChatUnifiedorder.setNonce_str(UUID.randomUUID().toString().replace("-", ""));
        weChatUnifiedorder.setBody(desc);
        weChatUnifiedorder.setOut_trade_no(orderId);
        weChatUnifiedorder.setTotal_fee(money);
        weChatUnifiedorder.setSpbill_create_ip("192.168.1.1");
        weChatUnifiedorder.setNotify_url(this.weChatApp.getPayBackUrl());
        weChatUnifiedorder.setTrade_type(payType);
        if ("JSAPI".equals(payType)) {
            weChatUnifiedorder.setOpenid(openId);
        }
        if ("SUCCESS".equals((weChatUnifiedorderResult = this.weChatApp.payUnifiedorder(weChatUnifiedorder)).getReturn_code())) {
            WeChatPayResult weChatPay = new WeChatPayResult();
            if ("SUCCESS".equals(weChatUnifiedorderResult.getResult_code())) {
                RemexConstants.logger.info((Object)"\u5fae\u4fe1\u4ed8\u6b3e\u9884\u4e0b\u5355\u6210\u529f\uff01");
                weChatPay.setCode(weChatUnifiedorderResult.getResult_code());
                weChatPay.setPrepay_id(weChatUnifiedorderResult.getPrepay_id());
                weChatPay.setUrl(weChatUnifiedorderResult.getCode_url());
                return weChatPay;
            }
            RemexConstants.logger.info((Object)("\u5fae\u4fe1\u4ed8\u6b3e\u53d1\u751f\u9519\u8bef\uff01\u9519\u8bef\u4ee3\u7801\uff1a" + weChatUnifiedorderResult.getErr_code() + "\u9519\u8bef\u539f\u56e0\uff1a" + weChatUnifiedorderResult.getErr_code_des()));
            weChatPay.setCode(weChatUnifiedorderResult.getErr_code());
            weChatPay.setMsg(weChatUnifiedorderResult.getErr_code_des());
            return weChatPay;
        }
        RemexConstants.logger.info((Object)"\u5fae\u4fe1\u4ed8\u6b3e\u9884\u7f51\u7edc\u9519\u8bef\uff01");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean messageTemplateSend(TemplateMessage templateMessage) {
        String access_token = WeChat.getWeChatApp().getAccess_token();
        Assert.notNull(access_token, "ERROR", "null access_token");
        Assert.notNull(templateMessage, "ERROR", "empty templateMessage");
        String data = JsonHelper.toJsonString(templateMessage);
        WeChatTemplateMessage weChatTemplateMessage = new WeChatTemplateMessage();
        weChatTemplateMessage.setTouser(templateMessage.getTouser());
        weChatTemplateMessage.setUrl(templateMessage.getUrl());
        weChatTemplateMessage.setTemplate_id(templateMessage.getTemplate_id());
        weChatTemplateMessage.setTopcolor(templateMessage.getTopcolor());
        weChatTemplateMessage.setData(data);
        WeChatMsg weChatMsg = new WeChatMsg();
        weChatMsg.setFromUserName(WeChat.getWeChatApp().getAppid());
        weChatMsg.setToUserName(templateMessage.getTouser());
        weChatMsg.setContent(templateMessage.getData().get("first").getValue());
        weChatMsg.setWxCreateTime(System.currentTimeMillis());
        try {
            WeChactMessageResult weChectMessageResult = this.weChatApp.templatMsgSend(templateMessage);
            weChatTemplateMessage.setErrcode(weChectMessageResult.getErrcode());
            weChatTemplateMessage.setErrmsg(weChectMessageResult.getErrmsg());
            weChatTemplateMessage.setMsgid(weChectMessageResult.getMsgid());
            weChatMsg.setErrcode(weChectMessageResult.getErrcode());
            weChatMsg.setErrmsg(weChectMessageResult.getErrmsg());
        }
        finally {
            Database.getSession().store(weChatTemplateMessage);
            Database.getSession().store(weChatMsg);
        }
        return "0".equals(weChatTemplateMessage.getErrcode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendCustomWeChatMsg(String openId, String msgContent) {
        String access_token = WeChat.getWeChatApp().getAccess_token();
        Assert.notNull(access_token, "ERROR", "invalid access_token");
        Assert.notNull(msgContent, "ERROR", "invalid msgContent");
        CustomMsg customMsg = new CustomMsg();
        customMsg.setTouser(openId);
        customMsg.setMsgtype("text");
        customMsg.setText(new CustomMsgData(msgContent));
        WeChatMsg weChatMsg = new WeChatMsg();
        weChatMsg.setFromUserName(WeChat.getWeChatApp().getAppid());
        weChatMsg.setToUserName(openId);
        weChatMsg.setContent(msgContent);
        weChatMsg.setWxCreateTime(System.currentTimeMillis());
        try {
            WeChactMessageResult weChectMessageResult = this.weChatApp.customMsgSend(customMsg);
            weChatMsg.setErrcode(weChectMessageResult.getErrcode());
            weChatMsg.setErrmsg(weChectMessageResult.getErrmsg());
        }
        finally {
            Database.getSession().store(weChatMsg);
        }
        return "0".equals(weChatMsg.getErrcode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendnewCustomWeChatMsg(String openId, String mpnewsId) {
        String access_token = WeChat.getWeChatApp().getAccess_token();
        Assert.notNull(access_token, "ERROR", "invalid access_token");
        Assert.notNull(mpnewsId, "ERROR", "invalid msgContent");
        CustomMsg customMsg = new CustomMsg();
        customMsg.setTouser(openId);
        customMsg.setMsgtype("mpnews");
        CustomMsgData customMsgData = new CustomMsgData(null);
        customMsgData.setMedia_id(mpnewsId);
        customMsg.setMpnews(customMsgData);
        String data = JsonHelper.toJsonString(customMsg);
        WeChatMsg weChatMsg = new WeChatMsg();
        weChatMsg.setFromUserName(WeChat.getWeChatApp().getAppid());
        weChatMsg.setToUserName(openId);
        weChatMsg.setContent(data);
        weChatMsg.setWxCreateTime(System.currentTimeMillis());
        try {
            WeChactMessageResult weChectMessageResult = this.weChatApp.customMsgSend(customMsg);
            weChatMsg.setErrcode(weChectMessageResult.getErrcode());
            weChatMsg.setErrmsg(weChectMessageResult.getErrmsg());
        }
        finally {
            Database.getSession().store(weChatMsg);
            return "0".equals(weChatMsg.getErrcode());
        }
    }

    public void everyWeChatUserOpenId(Consumer<String> openIdConsumer) {
        WeChatUserOpenIdList weChatUserOpenIdList = this.weChatApp.obtainOpenIdList("");
        do {
            if (!Judgment.nullOrBlank(weChatUserOpenIdList.getErrcode()) || weChatUserOpenIdList.getData() == null || weChatUserOpenIdList.getData().getOpenid() == null) {
                throw new BsException("\u5fae\u4fe1--\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            weChatUserOpenIdList.getData().getOpenid().forEach(openIdConsumer);
        } while (!Judgment.nullOrBlank((weChatUserOpenIdList = this.weChatApp.obtainOpenIdList(weChatUserOpenIdList.getNext_openid())).getNext_openid()));
    }

    public File getMediaAsFile(String media_id, String filePath) {
        Param fileParam = new Param();
        this.weChatApp.media_get(media_id, inputStream -> {
            fileParam.param = FileHelper.saveFile(filePath, inputStream);
        });
        return (File)fileParam.param;
    }
}

