/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.wechat.config;

import cn.remex.RemexConstants;
import cn.remex.core.util.Assert;
import cn.remex.core.util.JsonHelper;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.MapHelper;
import cn.remex.db.Database;
import cn.remex.db.model.cert.AuthUser;
import cn.remex.db.sql.WhereRuleOper;
import cn.remex.wechat.WeChat;
import cn.remex.wechat.beans.WeChatAccessToken;
import cn.remex.wechat.beans.WeChatResult;
import cn.remex.wechat.beans.WeChatUserInfo;
import cn.remex.wechat.beans.WeChatUserOpenIdList;
import cn.remex.wechat.beans.menu.Button;
import cn.remex.wechat.beans.menu.MenuButtons;
import cn.remex.wechat.beans.messages.CustomMsg;
import cn.remex.wechat.beans.messages.TemplateMessage;
import cn.remex.wechat.beans.messages.WeChactMessageResult;
import cn.remex.wechat.beans.paymch.WeChatUnifiedorder;
import cn.remex.wechat.beans.paymch.WeChatUnifiedorderResult;
import cn.remex.wechat.beans.qy.WeChatQyUserInfo;
import cn.remex.wechat.beans.ticket.JsapiTicket;
import cn.remex.wechat.beans.ticket.WeChatQrcodeTicketResult;
import cn.remex.wechat.config.WeChatAppType;
import cn.remex.wechat.models.WeChatToken;
import cn.remex.wechat.models.WeChatUser;
import cn.remex.wechat.utils.SHA1;
import cn.remex.wechat.utils.Signature;
import cn.remex.wechat.utils.WeChatException;
import cn.remex.wechat.utils.WeChatUtils;
import cn.remex.wechat.utils.WeChatWXBizMsgCrypt;
import cn.remex.wechat.utils.mp.aes.WXBizMsgCrypt;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.springframework.beans.factory.InitializingBean;

public class WeChatApp
implements InitializingBean {
    private WeChatAppType type = WeChatAppType.mp;
    private boolean defaultApp;
    private String appName;
    private String appid;
    private String token;
    private String secret;
    private String encodingAESKey;
    private String agentid = "0";
    private String subscribeMsg;
    private String payBackUrl;
    private String redirectDomain;
    private Map<String, String> stateRedirects;
    private Map<String, String> wxClickEventMsgs;
    private List<Button> menus;
    private String mchid;
    private String key;

    public WeChatApp(String appid, String agentid, String redirectDomain) {
        this.appid = appid;
        this.agentid = agentid;
        this.redirectDomain = redirectDomain;
    }

    public void afterPropertiesSet() throws Exception {
        WeChat.createWeChatAppConfig(this);
    }

    public String getAccess_token() {
        WeChatToken weChatToken = Database.createDbCvo(WeChatToken.class).filterBy(WeChatToken::getValid, WhereRuleOper.eq, (Object)"true").filterBy(WeChatToken::getType, WhereRuleOper.eq, (Object)WeChatToken.WeChatTokenType.accessToken).filterBy(WeChatToken::getAgentid, WhereRuleOper.eq, (Object)this.agentid).filterBy(WeChatToken::getAppid, WhereRuleOper.eq, (Object)this.appid).ready().queryBean();
        LocalDateTime localDateTimenow = LocalDateTime.now();
        if (!Judgment.nullOrBlank(weChatToken)) {
            LocalDateTime localDateTime = LocalDateTime.parse(weChatToken.getAccessTime());
            if (localDateTimenow.until(localDateTime, ChronoUnit.SECONDS) > -7000L) {
                return weChatToken.getAccessToken();
            }
            weChatToken.setValid(false);
            Database.getSession().store(weChatToken);
        }
        Assert.notNullAndEmpty(this.appid, "ERROR", "appid \u4e0d\u80fd\u4e3a\u7a7a~\uff01");
        Assert.notNullAndEmpty(this.secret, "ERROR", "secret \u4e0d\u80fd\u4e3a\u7a7a~\uff01");
        WeChatAccessToken weChectAccessToken = WeChatUtils.invokeApiReturnBean(this, "", WeChatAccessToken.class, WeChatUtils.WeChatApi.access_token, this.appid, this.secret);
        WeChatToken weChatToken1 = new WeChatToken();
        weChatToken1.setAccessToken(weChectAccessToken.getAccess_token());
        weChatToken1.setAccessTime(localDateTimenow.toString());
        weChatToken1.setAppid(this.appid);
        weChatToken1.setAgentid(this.agentid);
        weChatToken1.setType(WeChatToken.WeChatTokenType.accessToken);
        weChatToken1.setValid(true);
        Database.getSession().store(weChatToken1);
        return weChectAccessToken.getAccess_token();
    }

    public String getJsapi_ticket() {
        WeChatToken weChatToken = Database.createDbCvo(WeChatToken.class).filterBy(WeChatToken::getValid, WhereRuleOper.eq, (Object)"true").filterBy(WeChatToken::getType, WhereRuleOper.eq, (Object)WeChatToken.WeChatTokenType.jsapiToken).filterBy(WeChatToken::getAgentid, WhereRuleOper.eq, (Object)this.agentid).filterBy(WeChatToken::getAppid, WhereRuleOper.eq, (Object)this.appid).ready().queryBean();
        LocalDateTime localDateTimenow = LocalDateTime.now();
        if (!Judgment.nullOrBlank(weChatToken)) {
            LocalDateTime localDateTime = LocalDateTime.parse(weChatToken.getAccessTime());
            if (localDateTimenow.until(localDateTime, ChronoUnit.SECONDS) > -7000L) {
                return weChatToken.getTicket();
            }
            weChatToken.setValid(false);
            Database.getSession().store(weChatToken);
        }
        WeChatAccessToken WeChatAccessToken2 = WeChatUtils.invokeApiReturnBean(this, "", WeChatAccessToken.class, WeChatUtils.WeChatApi.jsapi_ticket, this.getAccess_token());
        WeChatToken weChatToken1 = new WeChatToken();
        weChatToken1.setTicket(WeChatAccessToken2.getTicket());
        weChatToken1.setAccessTime(localDateTimenow.toString());
        weChatToken1.setAppid(this.appid);
        weChatToken1.setAgentid(this.agentid);
        weChatToken1.setType(WeChatToken.WeChatTokenType.jsapiToken);
        weChatToken1.setValid(true);
        Database.getSession().store(weChatToken1);
        return WeChatAccessToken2.getTicket();
    }

    public WeChatQrcodeTicketResult qrcode_create_limitScene(String scene_str) {
        RemexConstants.logger.info((Object)("\u5fae\u4fe1\u4e8c\u7ef4\u7801\u5185\u5bb9\uff1a" + scene_str));
        Assert.notNullAndEmpty(scene_str, "WEIXIN_ARGS_INVALID", "\u5fae\u4fe1\u4e8c\u7ef4\u7801\u5185\u5bb9\uff01");
        String json = "{\"action_name\": \"QR_LIMIT_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"" + scene_str + "\"}}}";
        WeChatQrcodeTicketResult weChatQrcodeTicketResult = WeChatUtils.invokeApiReturnBean(this, json, WeChatQrcodeTicketResult.class, WeChatUtils.WeChatApi.qrcode_create, this.getAccess_token());
        return weChatQrcodeTicketResult;
    }

    public WeChatQrcodeTicketResult qrcode_create_scene(String scene_id, String expire_seconds) {
        Assert.notNullAndEmpty(scene_id, "WEIXIN_ARGS_INVALID", "\u5fae\u4fe1\u4e8c\u7ef4\u7801\u5185\u5bb9\uff01");
        expire_seconds = Judgment.nullOrBlank(expire_seconds) ? "200" : expire_seconds;
        String json = "{\"action_name\": \"QR_SCENE\", \"action_info\": {\"scene\": {\"scene_id\": \"" + scene_id + "\"}}}";
        WeChatQrcodeTicketResult weChatQrcodeTicketResult = WeChatUtils.invokeApiReturnBean(this, json, WeChatQrcodeTicketResult.class, WeChatUtils.WeChatApi.qrcode_create, this.getAccess_token());
        return weChatQrcodeTicketResult;
    }

    public String showqrcode(String qr_tiket) {
        return this.obtainApiUrl(WeChatUtils.WeChatApi.showqrcode, qr_tiket);
    }

    public String oauth2_authorize(String redirectUrl, String state) {
        return this.obtainApiUrl(WeChatUtils.WeChatApi.oauth2_authorize, this.appid, redirectUrl, state);
    }

    public WeChatUnifiedorderResult payUnifiedorder(WeChatUnifiedorder weChatUnifiedorder) {
        Map<String, String> map = MapHelper.objectToFlat(weChatUnifiedorder);
        if (!Judgment.nullOrBlank(this.getKey())) {
            String sign = Signature.generateSign(map, this.getKey());
            weChatUnifiedorder.setSign(sign);
        }
        return WeChatUtils.invokeApiReturnXml(this, weChatUnifiedorder, WeChatUnifiedorderResult.class, WeChatUtils.WeChatApi.payUnifiedorder, new String[0]);
    }

    public WeChactMessageResult templatMsgSend(TemplateMessage templateMessage) {
        return WeChatUtils.invokeApiReturnBean(this, JsonHelper.toJsonString(templateMessage), WeChactMessageResult.class, WeChatUtils.WeChatApi.templatMsgSend, this.getAccess_token());
    }

    public WeChactMessageResult customMsgSend(CustomMsg customMsg) {
        return WeChatUtils.invokeApiReturnBean(this, JsonHelper.toJsonString(customMsg), WeChactMessageResult.class, WeChatUtils.WeChatApi.customMsgSend, this.getAccess_token());
    }

    public WeChatResult menuCreate(MenuButtons menuButtons) {
        String json = JsonHelper.toJsonString(MapHelper.toMap("button", menuButtons == null ? this.menus : null));
        WeChatResult WeChatResult2 = WeChatUtils.invokeApiReturnBean(this, json, WeChatResult.class, WeChatUtils.WeChatApi.menu_create, this.getAccess_token(), this.agentid);
        return WeChatResult2;
    }

    public String obtainOpenidByCode(String code) {
        Assert.isTrue(this.type == WeChatAppType.mp, "WEIXIN_CONFIG_ERROR", "\u53ea\u6709\u670d\u52a1\u53f7\u624d\u80fd\u8c03\u7528\u6b64\u63a5\u53e3\uff1agetuserinfo");
        JsonNode jsonRoot = WeChatUtils.invokeApiReturnJson(this, "", WeChatUtils.WeChatApi.oauth2_access_token, this.appid, this.secret, code);
        return JsonHelper.readString(jsonRoot, "openid");
    }

    public WeChatQyUserInfo getuserinfo(String code) {
        Assert.isTrue(this.type == WeChatAppType.qy, "WEIXIN_CONFIG_ERROR", "\u53ea\u6709\u4f01\u4e1a\u53f7\u624d\u80fd\u8c03\u7528\u6b64\u63a5\u53e3\uff1agetuserinfo");
        JsonNode jsonRoot = WeChatUtils.invokeApiReturnJson(this, "", WeChatUtils.WeChatApi.getuserinfo, this.getAccess_token(), code);
        WeChatQyUserInfo userInfo = new WeChatQyUserInfo();
        userInfo.setOpenId(JsonHelper.readString(jsonRoot, "OpenId"));
        userInfo.setUserId(JsonHelper.readString(jsonRoot, "UserId"));
        return userInfo;
    }

    public WeChatQyUserInfo getLoginInfo(String code) {
        Assert.isTrue(this.type == WeChatAppType.qy, "WEIXIN_CONFIG_ERROR", "\u53ea\u6709\u4f01\u4e1a\u53f7\u624d\u80fd\u8c03\u7528\u6b64\u63a5\u53e3\uff1agetLoginInfo");
        JsonNode jsonRoot = WeChatUtils.invokeApiReturnJson(this, "", WeChatUtils.WeChatApi.get_login_info, this.getAccess_token(), code);
        WeChatQyUserInfo userInfo = new WeChatQyUserInfo();
        userInfo.setOpenId(JsonHelper.readString(jsonRoot, "OpenId"));
        userInfo.setUserId(JsonHelper.readString(jsonRoot, "UserId"));
        return userInfo;
    }

    public WeChatUser obtainAuthUserByCode(String code) {
        String openid;
        WeChatUser weChatUser = new WeChatUser();
        if (this.type == WeChatAppType.qy) {
            WeChatQyUserInfo weChatQyUserInfo = this.getuserinfo(code);
            String userid = weChatQyUserInfo.getUserId();
            openid = weChatQyUserInfo.getOpenId();
            if (!Judgment.nullOrBlank(userid)) {
                AuthUser authUser = Database.select(AuthUser.class).filterBy(AuthUser::getStaffNo, WhereRuleOper.eq, (Object)userid).withBase().rowCount(1).execute().obtainBean();
                if (null != authUser) {
                    weChatUser.setAuthUser(authUser);
                } else {
                    openid = this.openIdFromUserId(userid);
                }
            }
        } else {
            openid = this.obtainOpenidByCode(code);
        }
        if (!Judgment.nullOrBlank(openid)) {
            AuthUser authUser = Database.select(AuthUser.class).filterBy(AuthUser::getOpenid, WhereRuleOper.eq, (Object)openid).withBase().rowCount(1).execute().obtainBean();
            weChatUser.setAuthUser(authUser);
        }
        weChatUser.setOpenid(openid);
        return weChatUser;
    }

    public void media_get(String mediaId, Consumer<InputStream> consumer) {
        WeChatUtils.invokeApiHandleStream(this, "", consumer, WeChatUtils.WeChatApi.media_get, this.getAccess_token(), mediaId);
    }

    public WeChatUserInfo userInfo(String openId) {
        Assert.notNullAndEmpty(openId, "OPENID_INVALID", "\u7528\u6237openId \u4e0d\u80fd\u4e3a\u7a7a~\uff01");
        WeChatUserInfo weChatUserInfo = WeChatUtils.invokeApiReturnBean(this, "", WeChatUserInfo.class, WeChatUtils.WeChatApi.userInfo, this.getAccess_token(), openId);
        String nickname = weChatUserInfo.getNickname();
        if (!Judgment.nullOrBlank(nickname)) {
            weChatUserInfo.setNickname(nickname.replaceAll("[^\\w\u4e00-\u9fa5]", ""));
        }
        return "0".equals(weChatUserInfo.getSubscribe()) ? null : weChatUserInfo;
    }

    public String openIdFromUserId(String userId) {
        Assert.isTrue(this.type == WeChatAppType.qy, "WEIXIN_CONFIG_ERROR", "\u53ea\u6709\u4f01\u4e1a\u53f7\u624d\u80fd\u8c03\u7528\u6b64\u63a5\u53e3\uff1auserId to openId");
        String json = String.format("{\"userid\": \"%s\"}", userId);
        JsonNode jsonRoot = WeChatUtils.invokeApiReturnJson(this, json, WeChatUtils.WeChatApi.userid_to_openid, this.getAccess_token());
        Assert.nullOrEmpty(JsonHelper.readString(jsonRoot, "errcode"), "FAIL", "\u4f01\u4e1a\u4e2d\u8f6c\u6362userId to openId \u5931\u8d25");
        return JsonHelper.readString(jsonRoot, "openid");
    }

    public JsapiTicket signJsApiBySHA(String url) {
        Assert.notNullAndEmpty(url, "ERROR", "jsapi \u7b7e\u540d\u65f6\uff0curl\u4e0d\u80fd\u4e3a\u7a7a");
        String nonceStr = UUID.randomUUID().toString();
        String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
        String sbstr = "jsapi_ticket=" + this.getJsapi_ticket() + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + url.split("#")[0];
        RemexConstants.logger.info((Object)("jsapi\u7b7e\u540d\u5b57\u7b26\u4e32\u4e3a\uff1a" + sbstr));
        String signature = SHA1.SHA1(sbstr);
        RemexConstants.logger.info((Object)("jsapi\u7b7e\u540d\u4e3a\uff1a" + signature));
        JsapiTicket ret = new JsapiTicket();
        ret.setAppId(this.getAppid());
        ret.setNonceStr(nonceStr);
        ret.setTimestamp(timestamp);
        ret.setSignature(signature);
        ret.setUrl(url);
        return ret;
    }

    public WeChatUserOpenIdList obtainOpenIdList(String openId) {
        return WeChatUtils.invokeApiReturnBean(this, "", WeChatUserOpenIdList.class, WeChatUtils.WeChatApi.pulluserInfo, this.getAccess_token(), openId);
    }

    public String obtainStateRedirect(String state) {
        Assert.notNull(this.stateRedirects, "WEIXIN_CONFIG_ERROR", "\u6ca1\u6709\u4e3a\u5fae\u4fe1\u5e94\u7528" + this.appid + "\u914d\u7f6e\u5177\u4f53\u7684state_redirect\u53c2\u6570\u3002");
        String stateRedirect = this.stateRedirects.get(state);
        Assert.notNullAndEmpty(stateRedirect, "WEIXIN_CONFIG_ERROR", "\u5fae\u4fe1\u5e94\u7528" + this.appid + "\u7684\u914d\u7f6e\u5177\u4f53\u7684state_redirect\u53c2\u6570state=" + state + "\u914d\u7f6e\u4e3a\u7a7a");
        return stateRedirect;
    }

    public String obtainClickEventMsg(String eventKey) {
        Assert.notNull(this.wxClickEventMsgs, "WEIXIN_CONFIG_ERROR", "\u6ca1\u6709\u4e3a\u5fae\u4fe1\u5e94\u7528" + this.appid + "\u914d\u7f6e\u5177\u4f53\u7684\u83dc\u5355\u5355\u51fb\u4e8b\u4ef6wxClickEventMsgs\u53c2\u6570\u3002");
        String clickEventMsg = this.wxClickEventMsgs.get(eventKey);
        Assert.notNullAndEmpty(clickEventMsg, "WEIXIN_CONFIG_ERROR", "\u5fae\u4fe1\u5e94\u7528" + this.appid + "\u7684\u914d\u7f6e\u5177\u4f53\u7684\u83dc\u5355\u5355\u51fb\u4e8b\u4ef6wxClickEventMsgs\u53c2\u6570eventKey=" + eventKey + "\u914d\u7f6e\u4e3a\u7a7a");
        return clickEventMsg;
    }

    public String obtainApiUrl(WeChatUtils.WeChatApi apiKey, String ... args) {
        return String.format(WeChat.getApiUrl(this.type, apiKey), args);
    }

    private WeChatWXBizMsgCrypt obtainWXBizMsgCrypt() {
        try {
            if (this.type == WeChatAppType.qy) {
                return new cn.remex.wechat.utils.qy.aes.WXBizMsgCrypt(this.getToken(), this.getEncodingAESKey(), this.appid);
            }
            return new WXBizMsgCrypt(this.getToken(), this.getEncodingAESKey(), this.appid);
        }
        catch (Exception e) {
            throw new WeChatException("WEIXIN_CONFIG_ERROR", e.getMessage(), e);
        }
    }

    public String encryptMsg(String replyMsg, String timeStamp, String nonce) {
        try {
            if (Judgment.nullOrBlank(this.encodingAESKey)) {
                return replyMsg;
            }
            return this.obtainWXBizMsgCrypt().encryptMsg(replyMsg, timeStamp, nonce);
        }
        catch (Exception e) {
            throw new WeChatException("WEIXIN_CONFIG_ERROR", "\u5fae\u4fe1\u4fe1\u606f\u52a0\u5bc6\u6253\u5305\u5931\u8d25", e);
        }
    }

    public String decryptMsg(String msgSignature, String timeStamp, String nonce, String postData) {
        try {
            if (Judgment.nullOrBlank(this.encodingAESKey)) {
                if (postData.indexOf("<Encrypt>") > 0) {
                    throw new WeChatException("WEIXIN_CONFIG_ERROR", "\u5fae\u4fe1\u670d\u52a1\u4e3a\u52a0\u5bc6\u6a21\u5f0f\uff0c\u9700\u8981\u914d\u7f6eencodingAESKey");
                }
                return postData;
            }
            return this.obtainWXBizMsgCrypt().decryptMsg(msgSignature, timeStamp, nonce, postData);
        }
        catch (Exception e) {
            throw new WeChatException("WEIXIN_CONFIG_ERROR", "\u5fae\u4fe1\u4fe1\u606f\u89e3\u5bc6\u6253\u5305\u5931\u8d25", e);
        }
    }

    public String verifyURL(String msgSignature, String timeStamp, String nonce, String echoStr) {
        try {
            if (Judgment.nullOrBlank(this.encodingAESKey)) {
                Assert.isTrue(SHA1.gen(this.getToken(), timeStamp, nonce).equals(msgSignature), "WEIXIN_CONFIG_ERROR", "\u4e0d\u52a0\u5bc6\u6a21\u5f0f\u4e0b\u7684\u5fae\u4fe1\u56de\u8c03URL\u9a8c\u8bc1\u5931\u8d25\uff0cmsgSignature=" + msgSignature + ",timeStamp=" + timeStamp + ",nonce=" + nonce + ",echoStr=" + echoStr);
                return echoStr;
            }
            return this.obtainWXBizMsgCrypt().verifyURL(msgSignature, timeStamp, nonce, echoStr);
        }
        catch (Exception e) {
            throw new WeChatException("WEIXIN_CONFIG_ERROR", "\u52a0\u5bc6\u6a21\u5f0f\u4e0b\u7684\u5fae\u4fe1\u56de\u8c03URL\u9a8c\u8bc1\u5931\u8d25\uff0cmsgSignature=" + msgSignature + ",timeStamp=" + timeStamp + ",nonce=" + nonce + ",echoStr=" + echoStr, e);
        }
    }

    public WeChatAppType getType() {
        return this.type;
    }

    public void setType(WeChatAppType type) {
        this.type = type;
    }

    public String getMchid() {
        return this.mchid;
    }

    public void setMchid(String mchid) {
        this.mchid = mchid;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public List<Button> getMenus() {
        return this.menus;
    }

    public void setMenus(List<Button> menus) {
        this.menus = menus;
    }

    public String getPayBackUrl() {
        return this.payBackUrl;
    }

    public void setPayBackUrl(String payBackUrl) {
        this.payBackUrl = payBackUrl;
    }

    public String getRedirectDomain() {
        return this.redirectDomain;
    }

    public void setRedirectDomain(String redirectDomain) {
        this.redirectDomain = redirectDomain;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Map<String, String> getStateRedirects() {
        return this.stateRedirects;
    }

    public void setStateRedirects(Map<String, String> stateRedirects) {
        this.stateRedirects = stateRedirects;
    }

    public String getSubscribeMsg() {
        return this.subscribeMsg;
    }

    public void setSubscribeMsg(String subscribeMsg) {
        this.subscribeMsg = subscribeMsg;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Map<String, String> getWxClickEventMsgs() {
        return this.wxClickEventMsgs;
    }

    public void setWxClickEventMsgs(Map<String, String> wxClickEventMsgs) {
        this.wxClickEventMsgs = wxClickEventMsgs;
    }

    public String getEncodingAESKey() {
        return this.encodingAESKey;
    }

    public void setEncodingAESKey(String encodingAESKey) {
        this.encodingAESKey = encodingAESKey;
    }

    public String getAgentid() {
        return this.agentid;
    }

    public void setAgentid(String agentid) {
        this.agentid = agentid;
    }

    public boolean isDefaultApp() {
        return this.defaultApp;
    }

    public void setDefaultApp(boolean defaultApp) {
        this.defaultApp = defaultApp;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

