/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.wechat;

import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.PropertyReader;
import cn.remex.wechat.config.WeChatApp;
import cn.remex.wechat.config.WeChatAppExt;
import cn.remex.wechat.config.WeChatAppType;
import cn.remex.wechat.utils.WeChatException;
import cn.remex.wechat.utils.WeChatUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class WeChat {
    public static String LINUX_PATH = File.separator + "data" + File.separator + "default" + File.separator + "wxxml";
    public static String WIN_PATH = "D:" + File.separator + "data" + File.separator + "default" + File.separator + "wxxml";
    public static String certLocalPath;
    public static String certPassword;
    private static Map<String, String> WeChatApiUrlMap;
    private static Map<String, WeChatApp> weChatAppConfigMap;
    private static WeChatApp defaultWeChatApp;

    public static void createWeChatAppConfig(WeChatApp weChatApp) {
        if (weChatAppConfigMap.size() == 0 || weChatApp.isDefaultApp()) {
            defaultWeChatApp = weChatApp;
        }
        weChatAppConfigMap.put(weChatApp.getAppid() + "-" + weChatApp.getAgentid(), weChatApp);
    }

    public static WeChatApp getWeChatApp() {
        return WeChat.getWeChatApp(null, null);
    }

    public static WeChatApp getWeChatApp(String appId) {
        return WeChat.getWeChatApp(appId, null);
    }

    public static WeChatApp getWeChatApp(String appId, String agentId) {
        WeChatApp curWeChatApp;
        if (Judgment.nullOrBlank(appId) && Judgment.nullOrBlank(agentId)) {
            curWeChatApp = defaultWeChatApp;
        } else if (!Judgment.nullOrBlank(appId) && Judgment.nullOrBlank(agentId)) {
            curWeChatApp = weChatAppConfigMap.get(appId + "-0");
        } else if (!Judgment.nullOrBlank(appId) && !Judgment.nullOrBlank(agentId)) {
            curWeChatApp = weChatAppConfigMap.get(appId + "-" + agentId);
        } else {
            throw new WeChatException("WEIXIN_CONFIG_ERROR", "appid\u4e3anull\uff0cagentid\u4e0d\u4e3anull\u65f6\uff0c\u65e0\u6cd5\u83b7\u5f97WeChatApp");
        }
        Assert.notNull(curWeChatApp, "WEIXIN_CONFIG_ERROR", "\u5fae\u4fe1\u914d\u7f6e\u6216Appid\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u5fae\u4fe1\u5e94\u7528\u5b9e\u4f8b\uff1aappId=" + appId);
        return curWeChatApp;
    }

    public static WeChatAppExt getWeChatAppExt() {
        return new WeChatAppExt(defaultWeChatApp);
    }

    public static WeChatAppExt getWeChatAppExt(String appId) {
        return new WeChatAppExt(weChatAppConfigMap.get(appId));
    }

    public static String getApiUrl(WeChatAppType type, WeChatUtils.WeChatApi key) {
        String url = WeChatApiUrlMap.get(type.toString() + "." + (Object)((Object)key));
        Assert.notNullAndEmpty(url, "WEIXIN_CONFIG_ERROR", "\u5fae\u4fe1ApiUrl\u6ca1\u6709\u518dwechat.properties\u6587\u4ef6\u4e2d\u914d\u7f6e\uff1a" + (Object)((Object)type) + "." + (Object)((Object)key));
        return url;
    }

    public static Map<String, WeChatApp> getWeChatAppConfigMap() {
        return weChatAppConfigMap;
    }

    static {
        WeChatApiUrlMap = PropertyReader.getPropertiesHashMap(WeChat.class, "/wechat.properties");
        weChatAppConfigMap = new HashMap<String, WeChatApp>();
    }
}

