/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.web.service;

import cn.remex.RemexConstants;
import cn.remex.contrib.appbeans.DataRvo;
import cn.remex.core.RemexApplication;
import cn.remex.core.exception.NestedException;
import cn.remex.core.net.HttpHelper;
import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.JsonHelper;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.MapHelper;
import cn.remex.core.util.PackageUtil;
import cn.remex.core.util.StringHelper;
import cn.remex.db.DbRvo;
import cn.remex.web.service.BsCvo;
import cn.remex.web.service.BsException;
import cn.remex.web.service.BsRvo;
import cn.remex.web.service.BusinessService;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public final class ServiceFactory {
    private static Map<String, Class<?>> bsMap = new HashMap();

    public static Map<String, Class<?>> getBsMap() {
        return bsMap;
    }

    public static void scanPackagesForBs(String bsPackage) {
        RemexConstants.logger.info((Object)("\u626b\u63cfBusinessPackage:" + bsPackage));
        Set<Class<?>> orbs = PackageUtil.getClasses(bsPackage);
        for (Class<?> c : orbs) {
            if (!c.isAnnotationPresent(BusinessService.class) || c.isInterface()) continue;
            String bsName = StringHelper.getClassSimpleName(c);
            if (bsMap.containsKey(bsName)) {
                throw new BsException("\u626b\u63cfBusinessPackage\u53d1\u73b0\u5f02\u5e38,\u6709\u91cd\u590d\u7684bsName:" + bsName);
            }
            bsMap.put(bsName, c);
        }
    }

    public static Object createBs(String bsName) {
        Class<?> bs = bsMap.get(bsName);
        if (null == bs) {
            throw new BsException("\u4e1a\u52a1\u670d\u52a1" + bsName + "\u672a\u5f00\u53d1\u6216\u8005\u88ab\u7ba1\u7406\u5458\u6452\u5f03\uff0c\u8bf7\u8054\u7cfb\u7ad9\u70b9\u7ba1\u7406\u5458\uff01");
        }
        try {
            return RemexApplication.getBean(bs, new String[0]);
        }
        catch (Exception e) {
            throw new BsException(bsName, e);
        }
    }

    public static BsRvo executeBs(String bs, String bsCmd, String pk, HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        BsRvo bsRvo;
        String contentType = request.getContentType();
        boolean isText = Judgment.nullOrBlank(contentType) || contentType.contains("text/html") || contentType.contains("text/xml");
        boolean isJson = !isText && Judgment.notEmpty(contentType) && contentType.contains("application/json");
        try {
            RemexConstants.logger.info((Object)("Executing Bs=" + bs + ";bsCmd=" + bsCmd));
            Assert.notNull(bsMap.get(bs), "BS_ERROR", "\u670d\u52a1\u672a\u5f00\u653e\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1API\u62fc\u5199\u662f\u5426\u6b63\u786e");
            BusinessService bsan = ReflectUtil.getMethodAnnotation(bsMap.get(bs), bsCmd, BusinessService.class);
            Assert.notNull(bsan, "BS_ERROR", "\u670d\u52a1\u672a\u8bbe\u7f6e@BusinessService\u6ce8\u89e3");
            Object bsObj = ServiceFactory.createBs(bs);
            Method cglibBsCmdMethod = ReflectUtil.getMethod(bsObj.getClass(), bsCmd);
            Method CmdMethod = ReflectUtil.getMethod(bsMap.get(bs), bsCmd);
            Parameter[] parameters = CmdMethod.getParameters();
            params = params == null ? new HashMap<String, Object>() : params;
            params.putAll(request.getParameterMap());
            if (bsan.withMultiPart() || Arrays.asList(parameters).stream().filter(parameter -> File.class.isAssignableFrom(parameter.getType())).findAny().isPresent()) {
                MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
                Iterator iter = multiRequest.getFileNames();
                while (iter.hasNext()) {
                    int pre = (int)System.currentTimeMillis();
                    String filename = (String)iter.next();
                    MultipartFile file = multiRequest.getFile(filename);
                    if (file != null) {
                        params.put("file", file);
                    }
                    RemexConstants.logger.info((Object)("\u5904\u7406multipart file=" + filename + ";size=" + file.getSize() + ";time=" + (System.currentTimeMillis() - (long)pre)));
                }
            }
            String requestBody = null;
            if (isJson && !Judgment.nullOrBlank(requestBody = HttpHelper.obtainHttpPack((InputStream)request.getInputStream()))) {
                HashMap examMap = new HashMap();
                HashMap<String, Object> finalParams = params;
                JsonHelper.eachNode(requestBody, (k, v) -> finalParams.put((String)k, v.toString().replaceAll("^\"", "").replaceAll("\"$", "")));
            }
            if (!Judgment.nullOrBlank(bsan.bodyParamName())) {
                requestBody = null != requestBody ? requestBody : HttpHelper.obtainHttpPack((InputStream)request.getInputStream());
                params.put(bsan.bodyParamName(), requestBody);
            }
            params.put("pk", Judgment.nullOrBlank(pk) ? params.get("id") : pk);
            ArrayList paramArra = new ArrayList();
            for (Parameter param : parameters) {
                Object paramObj;
                Class<?> paramType = param.getType();
                String paramName = param.getName();
                if (ReflectUtil.isSimpleType(paramType)) {
                    paramObj = ReflectUtil.caseObject(paramType, params.get(paramName), new Object[0]);
                    if (null == paramObj && ReflectUtil.isNumeralType(paramType)) {
                        paramObj = 0;
                    }
                } else if (isJson) {
                    paramObj = params.get(paramName);
                    paramObj = JsonHelper.toJavaObject(Judgment.nullOrBlank(paramObj) || !(paramObj instanceof String) ? requestBody : params.get(paramName).toString(), param.getParameterizedType());
                } else if (bsan.withMultiPart() && params.get(paramName) != null) {
                    paramObj = ReflectUtil.caseObject(paramType, params.get(paramName), new Object[0]);
                } else {
                    paramObj = ReflectUtil.invokeNewInstance(paramType);
                    MapHelper.objectFromFlat(paramObj, params);
                }
                if (BsCvo.class.isAssignableFrom(paramType)) {
                    BsCvo bsCvo = (BsCvo)paramObj;
                    if (bsCvo.getParams() != null) {
                        bsCvo.getParams().putAll(params);
                    } else {
                        bsCvo.setParams(params);
                    }
                    bsCvo.setContextPath(request.getContextPath());
                }
                paramArra.add(paramObj);
            }
            Object result = ReflectUtil.applyMethod(cglibBsCmdMethod, bsObj, paramArra.toArray());
            bsRvo = result instanceof BsRvo ? (BsRvo)result : (result instanceof DbRvo ? new DataRvo((DbRvo)result) : (null == result ? new BsRvo("SUCCESS", "OK", "NO_RESPONSE_BODY") : new BsRvo("SUCCESS", "OK", result)));
        }
        catch (NestedException e) {
            if ("BS_ERROR".equals(e.getErrorCode())) {
                RemexConstants.logger.warn((Object)"\u670d\u52a1\u672a\u5f00\u653e\u6216\u6ca1\u6709\u7f16\u5199@BusinessService\u6ce8\u89e3");
            } else if (Judgment.nullOrBlank(e.getErrorCode()) || e.getErrorCode().indexOf("ERROR".toString()) >= 0) {
                RemexConstants.logger.error((Object)("\u670d\u52a1\u9519\u8bef, code=" + e.getErrorCode() + ";msg=" + e.getMessage()), (Throwable)e);
            } else {
                RemexConstants.logger.warn((Object)("\u670d\u52a1\u5931\u8d25, code=" + e.getErrorCode() + ";msg=" + e.getMessage()));
            }
            bsRvo = new BsRvo(e.getErrorCode(), e.getMessage());
            bsRvo.setResponseContentType(RemexConstants.ResponseContentType.json);
            bsRvo.setResponseHandelParam("json");
        }
        catch (Throwable t) {
            RemexConstants.logger.error((Object)"\u8c03\u7528\u672c\u5730Bs\u670d\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", t);
            bsRvo = new BsRvo("FAIL", Judgment.nullOrBlank(t.getMessage()) ? "\u670d\u52a1\u53d1\u751f\u8fd0\u884c\u5f02\u5e38" : t.getMessage());
            bsRvo.setResponseContentType(RemexConstants.ResponseContentType.json);
            bsRvo.setResponseHandelParam("json");
        }
        return bsRvo;
    }

    private static Files[] uploadFiles(HttpServletRequest request) {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                String myFileName;
                int pre = (int)System.currentTimeMillis();
                MultipartFile file = multiRequest.getFile((String)iter.next());
                if (file == null || (myFileName = file.getOriginalFilename()).trim() == "") continue;
                System.out.println(myFileName);
            }
        }
        return null;
    }
}

